/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history.wholeTree;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.impl.VcsLogContentProvider;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import git4idea.i18n.GitBundle;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class SelectRevisionInGitLogAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(SelectRevisionInGitLogAction.class);

    public SelectRevisionInGitLogAction() {
        super(GitBundle.getString("vcs.history.action.gitlog"), GitBundle.getString("vcs.history.action.gitlog"), null);
    }

    public void actionPerformed(AnActionEvent event) {
        VcsLog log;
        Content[] contents;
        final Project project = (Project)event.getRequiredData(CommonDataKeys.PROJECT);
        final VcsRevisionNumber revision = SelectRevisionInGitLogAction.getRevisionNumber(event);
        if (revision == null) {
            return;
        }
        boolean logReady = SelectRevisionInGitLogAction.findLog(project) != null;
        final ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(ChangesViewContentManager.TOOLWINDOW_ID);
        ContentManager cm = window.getContentManager();
        for (Content content : contents = cm.getContents()) {
            if (!"Log".equals(content.getDisplayName())) continue;
            cm.setSelectedContent(content);
            break;
        }
        if ((log = SelectRevisionInGitLogAction.findLog(project)) == null) {
            SelectRevisionInGitLogAction.showLogNotReadyMessage(project);
            return;
        }
        Runnable selectAndOpenLog = new Runnable(){

            @Override
            public void run() {
                Runnable selectCommit = new Runnable(){

                    @Override
                    public void run() {
                        SelectRevisionInGitLogAction.jumpToRevisionUnderProgress(project, log, revision);
                    }
                };
                if (!window.isVisible()) {
                    window.activate(selectCommit, true);
                } else {
                    selectCommit.run();
                }
            }
        };
        if (logReady) {
            selectAndOpenLog.run();
            return;
        }
        VcsLogManager logManager = VcsLogContentProvider.findLogManager((Project)project);
        if (logManager == null) {
            SelectRevisionInGitLogAction.showLogNotReadyMessage(project);
            return;
        }
        VcsLogUiImpl logUi = logManager.getLogUi();
        if (logUi == null) {
            SelectRevisionInGitLogAction.showLogNotReadyMessage(project);
            return;
        }
        logUi.invokeOnChange(selectAndOpenLog);
    }

    private static void showLogNotReadyMessage(Project project) {
        VcsBalloonProblemNotifier.showOverChangesView((Project)project, (String)GitBundle.getString("vcs.history.action.gitlog.error"), (MessageType)MessageType.WARNING, (NamedRunnable[])new NamedRunnable[0]);
    }

    private static VcsRevisionNumber getRevisionNumber(AnActionEvent event) {
        VcsFileRevision fileRevision;
        VcsRevisionNumber revision = (VcsRevisionNumber)event.getData(VcsDataKeys.VCS_REVISION_NUMBER);
        if (revision == null && (fileRevision = (VcsFileRevision)event.getData(VcsDataKeys.VCS_FILE_REVISION)) != null) {
            revision = fileRevision.getRevisionNumber();
        }
        return revision;
    }

    public void update(AnActionEvent e) {
        super.update(e);
        e.getPresentation().setEnabled(e.getProject() != null && VcsLogContentProvider.findLogManager((Project)e.getProject()) != null && (e.getData(VcsDataKeys.VCS_FILE_REVISION) != null || e.getData(VcsDataKeys.VCS_REVISION_NUMBER) != null));
    }

    private static VcsLog findLog(Project project) {
        VcsLogUiImpl ui;
        VcsLogManager manager = VcsLogContentProvider.findLogManager((Project)project);
        if (manager != null && (ui = manager.getLogUi()) != null) {
            return ui.getVcsLog();
        }
        return null;
    }

    private static void jumpToRevisionUnderProgress(Project project, VcsLog log, VcsRevisionNumber revision) {
        final Future future = log.jumpToReference(revision.asString());
        if (!future.isDone()) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Searching for revision " + revision.asString(), false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                public void run(ProgressIndicator indicator) {
                    try {
                        future.get();
                    }
                    catch (CancellationException ignored) {
                    }
                    catch (InterruptedException ignored) {
                    }
                    catch (ExecutionException e) {
                        LOG.error((Throwable)e);
                    }
                }
            });
        }
    }
}

