/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitCommit;
import git4idea.GitExecutionException;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class GitImpl
implements Git {
    private final Logger LOG = Logger.getInstance(Git.class);
    public static final String[] ERROR_INDICATORS = new String[]{"error", "remote: error", "fatal", "Cannot", "Could not", "Interactive rebase already started", "refusing to pull", "cannot rebase:", "conflict", "unable"};

    @Override
    public GitCommandResult init(Project project, VirtualFile root, GitLineHandlerListener ... listeners) {
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.INIT);
        for (GitLineHandlerListener listener : listeners) {
            h.addLineListener(listener);
        }
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        return GitImpl.run(h);
    }

    @Override
    public Set<VirtualFile> untrackedFiles(Project project, VirtualFile root, Collection<VirtualFile> files) throws VcsException {
        HashSet<VirtualFile> untrackedFiles = new HashSet<VirtualFile>();
        if (files == null) {
            untrackedFiles.addAll(this.untrackedFilesNoChunk(project, root, null));
        } else {
            for (List relativePaths : VcsFileUtil.chunkFiles((VirtualFile)root, files)) {
                untrackedFiles.addAll(this.untrackedFilesNoChunk(project, root, relativePaths));
            }
        }
        return untrackedFiles;
    }

    @Override
    public Collection<VirtualFile> untrackedFilesNoChunk(Project project, VirtualFile root, List<String> relativePaths) throws VcsException {
        String output;
        HashSet<VirtualFile> untrackedFiles = new HashSet<VirtualFile>();
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.LS_FILES);
        h.setSilent(true);
        h.addParameters("--exclude-standard", "--others", "-z");
        h.endOptions();
        if (relativePaths != null) {
            h.addParameters(relativePaths);
        }
        if (StringUtil.isEmptyOrSpaces((String)(output = h.run()))) {
            return untrackedFiles;
        }
        for (String relPath : output.split("\u0000")) {
            VirtualFile f = root.findFileByRelativePath(relPath);
            if (f == null) {
                this.LOG.info(String.format("VirtualFile for path [%s] is null", relPath));
                continue;
            }
            untrackedFiles.add(f);
        }
        return untrackedFiles;
    }

    @Override
    public GitCommandResult clone(final Project project, final File parentDirectory, final String url, final String clonedDirectoryName, final GitLineHandlerListener ... listeners) {
        return GitImpl.run(new Computable<GitLineHandler>(){

            public GitLineHandler compute() {
                GitLineHandler handler = new GitLineHandler(project, parentDirectory, GitCommand.CLONE);
                handler.setStdoutSuppressed(false);
                handler.setUrl(url);
                handler.addParameters("--progress");
                handler.addParameters(url);
                handler.addParameters(clonedDirectoryName);
                GitImpl.addListeners(handler, listeners);
                return handler;
            }
        });
    }

    @Override
    public GitCommandResult config(GitRepository repository, String ... params) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CONFIG);
        h.addParameters(params);
        return GitImpl.run(h);
    }

    @Override
    public GitCommandResult diff(GitRepository repository, List<String> parameters, String range) {
        GitLineHandler diff = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.DIFF);
        diff.addParameters(parameters);
        diff.addParameters(range);
        diff.setStdoutSuppressed(true);
        diff.setStderrSuppressed(true);
        diff.setSilent(true);
        return GitImpl.run(diff);
    }

    @Override
    public GitCommandResult checkAttr(GitRepository repository, Collection<String> attributes, Collection<VirtualFile> files) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CHECK_ATTR);
        h.addParameters(new ArrayList<String>(attributes));
        h.endOptions();
        h.addRelativeFiles(files);
        return GitImpl.run(h);
    }

    @Override
    public GitCommandResult stashSave(GitRepository repository, String message) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.STASH);
        h.addParameters("save");
        h.addParameters(message);
        return GitImpl.run(h);
    }

    @Override
    public GitCommandResult stashPop(GitRepository repository, GitLineHandlerListener ... listeners) {
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.STASH);
        handler.addParameters("pop");
        GitImpl.addListeners(handler, listeners);
        return GitImpl.run(handler);
    }

    @Override
    public List<GitCommit> history(GitRepository repository, String range) {
        try {
            return GitHistoryUtils.history(repository.getProject(), repository.getRoot(), range);
        }
        catch (VcsException e) {
            throw new GitExecutionException("Couldn't get [git log " + range + "] on repository [" + repository.getRoot() + "]", e);
        }
    }

    @Override
    public GitCommandResult merge(GitRepository repository, String branchToMerge, List<String> additionalParams, GitLineHandlerListener ... listeners) {
        GitLineHandler mergeHandler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.MERGE);
        mergeHandler.setSilent(false);
        mergeHandler.addParameters(branchToMerge);
        if (additionalParams != null) {
            mergeHandler.addParameters(additionalParams);
        }
        for (GitLineHandlerListener listener : listeners) {
            mergeHandler.addLineListener(listener);
        }
        return GitImpl.run(mergeHandler);
    }

    @Override
    public GitCommandResult checkout(GitRepository repository, String reference, String newBranch, boolean force, GitLineHandlerListener ... listeners) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CHECKOUT);
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        if (force) {
            h.addParameters("--force");
        }
        if (newBranch == null) {
            h.addParameters(reference);
        } else {
            h.addParameters("-b", newBranch, reference);
        }
        for (GitLineHandlerListener listener : listeners) {
            h.addLineListener(listener);
        }
        return GitImpl.run(h);
    }

    @Override
    public GitCommandResult checkoutNewBranch(GitRepository repository, String branchName, GitLineHandlerListener listener) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CHECKOUT.readLockingCommand());
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        h.addParameters("-b");
        h.addParameters(branchName);
        if (listener != null) {
            h.addLineListener(listener);
        }
        return GitImpl.run(h);
    }

    @Override
    public GitCommandResult createNewTag(GitRepository repository, String tagName, GitLineHandlerListener listener, String reference) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.TAG);
        h.setSilent(false);
        h.addParameters(tagName);
        if (!reference.isEmpty()) {
            h.addParameters(reference);
        }
        if (listener != null) {
            h.addLineListener(listener);
        }
        return GitImpl.run(h);
    }

    @Override
    public GitCommandResult branchDelete(GitRepository repository, String branchName, boolean force, GitLineHandlerListener ... listeners) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.BRANCH);
        h.setSilent(false);
        h.setStdoutSuppressed(false);
        h.addParameters(force ? "-D" : "-d");
        h.addParameters(branchName);
        for (GitLineHandlerListener listener : listeners) {
            h.addLineListener(listener);
        }
        return GitImpl.run(h);
    }

    @Override
    public GitCommandResult branchContains(GitRepository repository, String commit) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.BRANCH);
        h.addParameters("--contains", commit);
        return GitImpl.run(h);
    }

    @Override
    public GitCommandResult branchCreate(GitRepository repository, String branchName) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.BRANCH);
        h.setStdoutSuppressed(false);
        h.addParameters(branchName);
        return GitImpl.run(h);
    }

    @Override
    public GitCommandResult reset(GitRepository repository, GitResetMode mode, String target, GitLineHandlerListener ... listeners) {
        return GitImpl.reset(repository, mode.getArgument(), target, listeners);
    }

    @Override
    public GitCommandResult resetMerge(GitRepository repository, String revision) {
        return GitImpl.reset(repository, "--merge", revision, new GitLineHandlerListener[0]);
    }

    private static GitCommandResult reset(GitRepository repository, String argument, String target, GitLineHandlerListener ... listeners) {
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.RESET);
        handler.addParameters(argument);
        if (target != null) {
            handler.addParameters(target);
        }
        GitImpl.addListeners(handler, listeners);
        return GitImpl.run(handler);
    }

    @Override
    public GitCommandResult tip(GitRepository repository, String branchName) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REV_LIST);
        h.addParameters("-1");
        h.addParameters(branchName);
        return GitImpl.run(h);
    }

    @Override
    public GitCommandResult push(GitRepository repository, String remote, String url, String spec, boolean updateTracking, GitLineHandlerListener ... listeners) {
        return this.doPush(repository, remote, url, spec, false, updateTracking, null, listeners);
    }

    private GitCommandResult doPush(final GitRepository repository, final String remote, final String url, final String spec, final boolean force, final boolean updateTracking, final String tagMode, final GitLineHandlerListener ... listeners) {
        return this.runCommand(new Computable<GitLineHandler>(){

            public GitLineHandler compute() {
                GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.PUSH);
                if (url != null) {
                    h.setUrl(url);
                }
                h.setSilent(false);
                h.setStdoutSuppressed(false);
                GitImpl.addListeners(h, listeners);
                h.addProgressParameter();
                h.addParameters("--porcelain");
                h.addParameters(remote);
                h.addParameters(spec);
                if (updateTracking) {
                    h.addParameters("--set-upstream");
                }
                if (force) {
                    h.addParameters("--force");
                }
                if (tagMode != null) {
                    h.addParameters(tagMode);
                }
                return h;
            }
        });
    }

    @Override
    public GitCommandResult push(GitRepository repository, String remote, String url, String spec, GitLineHandlerListener ... listeners) {
        return this.push(repository, remote, url, spec, false, listeners);
    }

    @Override
    public GitCommandResult push(GitRepository repository, GitLocalBranch source, GitRemoteBranch target, boolean force, boolean updateTracking, String tagMode, GitLineHandlerListener ... listeners) {
        String url;
        GitRemote remote = target.getRemote();
        Collection<String> pushUrls = remote.getPushUrls();
        if (pushUrls.isEmpty()) {
            this.LOG.error("No urls or pushUrls are defined for " + remote);
            url = null;
        } else {
            url = pushUrls.iterator().next();
        }
        String spec = source.getFullName() + ":" + target.getNameForRemoteOperations();
        return this.doPush(repository, remote.getName(), url, spec, force, updateTracking, tagMode, listeners);
    }

    @Override
    public GitCommandResult show(GitRepository repository, String ... params) {
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.SHOW);
        handler.addParameters(params);
        return GitImpl.run(handler);
    }

    @Override
    public GitCommandResult cherryPick(GitRepository repository, String hash, boolean autoCommit, GitLineHandlerListener ... listeners) {
        GitLineHandler handler = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.CHERRY_PICK);
        handler.addParameters("-x");
        if (!autoCommit) {
            handler.addParameters("-n");
        }
        handler.addParameters(hash);
        GitImpl.addListeners(handler, listeners);
        handler.setSilent(false);
        handler.setStdoutSuppressed(false);
        return GitImpl.run(handler);
    }

    @Override
    public GitCommandResult getUnmergedFiles(GitRepository repository) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.LS_FILES);
        h.addParameters("--unmerged");
        h.setSilent(true);
        return GitImpl.run(h);
    }

    @Override
    public GitCommandResult fetch(final GitRepository repository, final String url, final String remote, final List<GitLineHandlerListener> listeners, final String ... params) {
        return this.runCommand(new Computable<GitLineHandler>(){

            public GitLineHandler compute() {
                GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.FETCH);
                h.setSilent(false);
                h.setStdoutSuppressed(false);
                h.setUrl(url);
                h.addParameters(remote);
                h.addParameters(params);
                h.addProgressParameter();
                GitVcs vcs = GitVcs.getInstance(repository.getProject());
                if (vcs != null && GitVersionSpecialty.SUPPORTS_FETCH_PRUNE.existsIn(vcs.getVersion())) {
                    h.addParameters("--prune");
                }
                GitImpl.addListeners(h, listeners);
                return h;
            }
        });
    }

    @Override
    public GitCommandResult addRemote(GitRepository repository, String name, String url) {
        GitLineHandler h = new GitLineHandler(repository.getProject(), repository.getRoot(), GitCommand.REMOTE);
        h.addParameters("add", name, url);
        return GitImpl.run(h);
    }

    @Override
    public GitCommandResult lsRemote(Project project, File workingDir, String url) {
        return this.doLsRemote(project, workingDir, url, url, new String[0]);
    }

    @Override
    public GitCommandResult lsRemote(Project project, VirtualFile workingDir, GitRemote remote, String ... additionalParameters) {
        return this.doLsRemote(project, VfsUtilCore.virtualToIoFile((VirtualFile)workingDir), remote.getName(), remote.getFirstUrl(), additionalParameters);
    }

    private GitCommandResult doLsRemote(final Project project, final File workingDir, final String remoteId, final String authenticationUrl, final String ... additionalParameters) {
        return GitImpl.run(new Computable<GitLineHandler>(){

            public GitLineHandler compute() {
                GitLineHandler h = new GitLineHandler(project, workingDir, GitCommand.LS_REMOTE);
                h.addParameters(additionalParameters);
                h.addParameters(remoteId);
                if (authenticationUrl != null) {
                    h.setUrl(authenticationUrl);
                } else {
                    GitImpl.this.LOG.error("No valid URLs for remote " + remoteId);
                }
                return h;
            }
        });
    }

    private static void addListeners(GitLineHandler handler, GitLineHandlerListener ... listeners) {
        GitImpl.addListeners(handler, Arrays.asList(listeners));
    }

    private static void addListeners(GitLineHandler handler, List<GitLineHandlerListener> listeners) {
        for (GitLineHandlerListener listener : listeners) {
            handler.addLineListener(listener);
        }
    }

    private static GitCommandResult run(Computable<GitLineHandler> handlerConstructor) {
        boolean success;
        boolean authFailed;
        final ArrayList<String> errorOutput = new ArrayList<String>();
        final ArrayList<String> output = new ArrayList<String>();
        final AtomicInteger exitCode = new AtomicInteger();
        final AtomicBoolean startFailed = new AtomicBoolean();
        final AtomicReference<Object> exception = new AtomicReference<Object>();
        int authAttempt = 0;
        do {
            errorOutput.clear();
            output.clear();
            exitCode.set(0);
            startFailed.set(false);
            exception.set(null);
            GitLineHandler handler = (GitLineHandler)handlerConstructor.compute();
            handler.addLineListener(new GitLineHandlerListener(){

                @Override
                public void onLineAvailable(String line, Key outputType) {
                    if (GitImpl.isError(line)) {
                        errorOutput.add(line);
                    } else {
                        output.add(line);
                    }
                }

                public void processTerminated(int code) {
                    exitCode.set(code);
                }

                public void startFailed(Throwable t) {
                    startFailed.set(true);
                    errorOutput.add("Failed to start Git process");
                    exception.set(t);
                }
            });
            handler.runInCurrentThread(null);
            authFailed = handler.hasHttpAuthFailed();
            boolean bl = success = !startFailed.get() && errorOutput.isEmpty() && (handler.isIgnoredErrorCode(exitCode.get()) || exitCode.get() == 0);
        } while (authFailed && authAttempt++ < 2);
        return new GitCommandResult(success, exitCode.get(), errorOutput, output, null);
    }

    private static GitCommandResult run(GitLineHandler handler) {
        return GitImpl.run((Computable<GitLineHandler>)new Computable.PredefinedValueComputable((Object)handler));
    }

    @Override
    public GitCommandResult runCommand(Computable<GitLineHandler> handlerConstructor) {
        return GitImpl.run(handlerConstructor);
    }

    @Override
    public GitCommandResult runCommand(final GitLineHandler handler) {
        return this.runCommand(new Computable<GitLineHandler>(){

            public GitLineHandler compute() {
                return handler;
            }
        });
    }

    private static boolean isError(String text) {
        for (String indicator : ERROR_INDICATORS) {
            if (!text.trim().toLowerCase().startsWith(indicator.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

