/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitSvnRemoteBranch;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchesCollection;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitConfigUtil;
import git4idea.config.GitVcsSettings;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryFiles;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import git4idea.validators.GitNewBranchNameValidator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.Icon;

public class GitBranchUtil {
    private static final Logger LOG = Logger.getInstance(GitBranchUtil.class);
    private static final Function<GitBranch, String> BRANCH_TO_NAME = new Function<GitBranch, String>(){

        public String apply(GitBranch input) {
            assert (input != null);
            return input.getName();
        }
    };
    private static final String NO_BRANCH_NAME = "(no branch)";

    private GitBranchUtil() {
    }

    public static GitBranchTrackInfo getTrackInfoForBranch(GitRepository repository, GitLocalBranch branch) {
        for (GitBranchTrackInfo trackInfo : repository.getBranchTrackInfos()) {
            if (!trackInfo.getLocalBranch().equals(branch)) continue;
            return trackInfo;
        }
        return null;
    }

    static String getCurrentBranchOrRev(Collection<GitRepository> repositories) {
        if (repositories.size() > 1) {
            GitMultiRootBranchConfig multiRootBranchConfig = new GitMultiRootBranchConfig(repositories);
            String currentBranch = multiRootBranchConfig.getCurrentBranch();
            LOG.assertTrue(currentBranch != null, (Object)("Repositories have unexpectedly diverged. " + (Object)((Object)multiRootBranchConfig)));
            return currentBranch;
        }
        assert (!repositories.isEmpty()) : "No repositories passed to GitBranchOperationsProcessor.";
        GitRepository repository = repositories.iterator().next();
        return GitBranchUtil.getBranchNameOrRev(repository);
    }

    public static Collection<String> convertBranchesToNames(Collection<? extends GitBranch> branches) {
        return Collections2.transform(branches, BRANCH_TO_NAME);
    }

    @Deprecated
    public static GitLocalBranch getCurrentBranch(Project project, VirtualFile root) {
        GitRepository repository = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root);
        if (repository != null) {
            return repository.getCurrentBranch();
        }
        LOG.info("getCurrentBranch: Repository is null for root " + root);
        return GitBranchUtil.getCurrentBranchFromGit(project, root);
    }

    private static GitLocalBranch getCurrentBranchFromGit(Project project, VirtualFile root) {
        GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.REV_PARSE);
        handler.addParameters("--abbrev-ref", "HEAD");
        handler.setSilent(true);
        try {
            String name = handler.run();
            if (!name.equals("HEAD")) {
                return new GitLocalBranch(name, GitBranch.DUMMY_HASH);
            }
            return null;
        }
        catch (VcsException e) {
            LOG.info("git rev-parse --abbrev-ref HEAD", (Throwable)e);
            return null;
        }
    }

    public static String getTrackedRemoteName(Project project, VirtualFile root, String branchName) throws VcsException {
        return GitConfigUtil.getValue(project, root, GitBranchUtil.trackedRemoteKey(branchName));
    }

    public static String getTrackedBranchName(Project project, VirtualFile root, String branchName) throws VcsException {
        return GitConfigUtil.getValue(project, root, GitBranchUtil.trackedBranchKey(branchName));
    }

    private static String trackedBranchKey(String branchName) {
        return "branch." + branchName + ".merge";
    }

    private static String trackedRemoteKey(String branchName) {
        return "branch." + branchName + ".remote";
    }

    @Deprecated
    public static GitRemoteBranch tracked(Project project, VirtualFile root, String branchName) throws VcsException {
        HashMap<String, String> result = new HashMap<String, String>();
        GitConfigUtil.getValues(project, root, null, result);
        String remoteName = result.get(GitBranchUtil.trackedRemoteKey(branchName));
        if (remoteName == null) {
            return null;
        }
        String branch = result.get(GitBranchUtil.trackedBranchKey(branchName));
        if (branch == null) {
            return null;
        }
        if (".".equals(remoteName)) {
            return new GitSvnRemoteBranch(branch, GitBranch.DUMMY_HASH);
        }
        GitRemote remote = GitBranchUtil.findRemoteByNameOrLogError(project, root, remoteName);
        if (remote == null) {
            return null;
        }
        return new GitStandardRemoteBranch(remote, branch, GitBranch.DUMMY_HASH);
    }

    @Deprecated
    public static GitRemote findRemoteByNameOrLogError(Project project, VirtualFile root, String remoteName) {
        GitRepository repository = GitUtil.getRepositoryForRootOrLogError(project, root);
        if (repository == null) {
            return null;
        }
        GitRemote remote = GitUtil.findRemoteByName(repository, remoteName);
        if (remote == null) {
            LOG.warn("Couldn't find remote with name " + remoteName);
            return null;
        }
        return remote;
    }

    public static Collection<String> getBranchNamesWithoutRemoteHead(Collection<GitRemoteBranch> remoteBranches) {
        return Collections2.filter(GitBranchUtil.convertBranchesToNames(remoteBranches), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                assert (input != null);
                return !input.equals("HEAD");
            }
        });
    }

    public static String stripRefsPrefix(String branchName) {
        if (branchName.startsWith("refs/heads/")) {
            return branchName.substring("refs/heads/".length());
        }
        if (branchName.startsWith("refs/remotes/")) {
            return branchName.substring("refs/remotes/".length());
        }
        if (branchName.startsWith("refs/tags/")) {
            return branchName.substring("refs/tags/".length());
        }
        return branchName;
    }

    public static String getBranchNameOrRev(GitRepository repository) {
        if (repository.isOnBranch()) {
            GitLocalBranch currentBranch = repository.getCurrentBranch();
            assert (currentBranch != null);
            return currentBranch.getName();
        }
        String currentRevision = repository.getCurrentRevision();
        return currentRevision != null ? currentRevision.substring(0, 7) : "";
    }

    public static String getNewBranchNameFromUser(Project project, Collection<GitRepository> repositories, String dialogTitle) {
        return Messages.showInputDialog((Project)project, (String)"Enter the name of new branch:", (String)dialogTitle, (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)GitNewBranchNameValidator.newInstance(repositories));
    }

    public static String getDisplayableBranchText(GitRepository repository) {
        GitLocalBranch branch;
        Repository.State state = repository.getState();
        if (state == Repository.State.DETACHED) {
            String currentRevision = repository.getCurrentRevision();
            assert (currentRevision != null) : "Current revision can't be null in DETACHED state, only on the fresh repository.";
            return DvcsUtil.getShortHash((String)currentRevision);
        }
        String prefix = "";
        if (state == Repository.State.MERGING || state == Repository.State.REBASING) {
            prefix = state.toString() + " ";
        }
        String branchName = (branch = repository.getCurrentBranch()) == null ? "" : branch.getName();
        return prefix + branchName;
    }

    public static GitRepository getCurrentRepository(Project project) {
        GitRepositoryManager manager = GitUtil.getRepositoryManager(project);
        VirtualFile file = DvcsUtil.getSelectedFile((Project)project);
        VirtualFile root = GitBranchUtil.getVcsRootOrGuess(project, file);
        return (GitRepository)manager.getRepositoryForRoot(root);
    }

    public static VirtualFile getVcsRootOrGuess(Project project, VirtualFile file) {
        VirtualFile root = DvcsUtil.getVcsRoot((Project)project, (VirtualFile)file);
        return root != null ? root : GitBranchUtil.guessGitRoot(project);
    }

    private static VirtualFile guessGitRoot(Project project) {
        VirtualFile recentRoot;
        String recentRootPath;
        LOG.debug("Guessing Git root...");
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        GitVcs gitVcs = GitVcs.getInstance(project);
        if (gitVcs == null) {
            LOG.debug("GitVcs not found.");
            return null;
        }
        VirtualFile[] gitRoots = vcsManager.getRootsUnderVcs((AbstractVcs)gitVcs);
        if (gitRoots.length == 0) {
            LOG.debug("No Git roots in the project.");
            return null;
        }
        if (gitRoots.length == 1) {
            VirtualFile onlyRoot = gitRoots[0];
            LOG.debug("Only one Git root in the project, returning: " + onlyRoot);
            return onlyRoot;
        }
        GitVcsSettings settings = GitVcsSettings.getInstance(project);
        if (settings != null && (recentRootPath = settings.getRecentRootPath()) != null && (recentRoot = VcsUtil.getVirtualFile((String)recentRootPath)) != null) {
            LOG.debug("Returning the recent root: " + recentRoot);
            return recentRoot;
        }
        VirtualFile projectBaseDir = project.getBaseDir();
        if (projectBaseDir == null) {
            VirtualFile firstRoot = gitRoots[0];
            LOG.debug("Project base dir is null, returning the first root: " + firstRoot);
            return firstRoot;
        }
        VirtualFile rootCandidate = null;
        for (VirtualFile root : gitRoots) {
            if (root.equals(projectBaseDir)) {
                return root;
            }
            if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)projectBaseDir, (boolean)true)) continue;
            rootCandidate = root;
        }
        LOG.debug("The best candidate: " + rootCandidate);
        if (rootCandidate == null) {
            rootCandidate = gitRoots[0];
        }
        LOG.debug("Returning the best candidate: " + rootCandidate);
        return rootCandidate;
    }

    public static Collection<String> getCommonBranches(Collection<GitRepository> repositories, boolean local) {
        Collection<Object> commonBranches = null;
        for (GitRepository repository : repositories) {
            Collection<Object> names;
            GitBranchesCollection branchesCollection = repository.getBranches();
            Collection<Object> collection = names = local ? GitBranchUtil.convertBranchesToNames(branchesCollection.getLocalBranches()) : GitBranchUtil.getBranchNamesWithoutRemoteHead(branchesCollection.getRemoteBranches());
            if (commonBranches == null) {
                commonBranches = names;
                continue;
            }
            commonBranches = ContainerUtil.intersection(commonBranches, names);
        }
        if (commonBranches != null) {
            ArrayList<String> common = new ArrayList<String>(commonBranches);
            Collections.sort(common);
            return common;
        }
        return Collections.emptyList();
    }

    public static Collection<String> getBranches(Project project, VirtualFile root, boolean localWanted, boolean remoteWanted, String containingCommit) throws VcsException {
        String[] split;
        String output;
        GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.BRANCH);
        handler.setSilent(true);
        handler.addParameters("--no-color");
        boolean remoteOnly = false;
        if (remoteWanted && localWanted) {
            handler.addParameters("-a");
            remoteOnly = false;
        } else if (remoteWanted) {
            handler.addParameters("-r");
            remoteOnly = true;
        }
        if (containingCommit != null) {
            handler.addParameters("--contains", containingCommit);
        }
        if ((output = handler.run()).trim().length() == 0) {
            try {
                String head = FileUtil.loadFile((File)new File(root.getPath(), GitRepositoryFiles.GIT_HEAD), (Charset)CharsetToolkit.UTF8_CHARSET).trim();
                String prefix = "ref: refs/heads/";
                return head.startsWith("ref: refs/heads/") ? Collections.singletonList(head.substring("ref: refs/heads/".length())) : Collections.emptyList();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                return Collections.emptyList();
            }
        }
        ArrayList branches = ContainerUtil.newArrayList();
        for (String b : split = output.split("\n")) {
            boolean isRemote;
            if ((b = b.substring(2).trim()).equals(NO_BRANCH_NAME)) continue;
            String remotePrefix = null;
            if (b.startsWith("remotes/")) {
                remotePrefix = "remotes/";
            } else if (b.startsWith("refs/remotes/")) {
                remotePrefix = "refs/remotes/";
            }
            boolean bl = isRemote = remotePrefix != null || remoteOnly;
            if (isRemote) {
                int idx;
                if (!remoteOnly) {
                    b = b.substring(remotePrefix.length());
                }
                if ((idx = b.indexOf("HEAD ->")) > 0) continue;
            }
            branches.add(b);
        }
        return branches;
    }
}

