/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogUi;
import git4idea.branch.DeepComparator;
import git4idea.repo.GitRepositoryManager;
import java.util.Map;

public class DeepComparatorHolder
implements Disposable {
    private final Project myProject;
    private final GitRepositoryManager myRepositoryManager;
    private final Map<VcsLogUi, DeepComparator> myComparators;

    private DeepComparatorHolder(Project project, GitRepositoryManager repositoryManager) {
        this.myProject = project;
        this.myRepositoryManager = repositoryManager;
        this.myComparators = ContainerUtil.newHashMap();
        Disposer.register((Disposable)project, (Disposable)this);
    }

    public DeepComparator getInstance(VcsLogUi ui) {
        DeepComparator comparator = this.myComparators.get(ui);
        if (comparator == null) {
            comparator = new DeepComparator(this.myProject, this.myRepositoryManager, ui, this);
            this.myComparators.put(ui, comparator);
        }
        return comparator;
    }

    public void dispose() {
        this.myComparators.clear();
    }
}

