/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogDataProvider;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogListener;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.impl.HashImpl;
import git4idea.GitBranch;
import git4idea.branch.DeepComparatorHolder;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerAdapter;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import gnu.trove.TIntHashSet;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class DeepComparator
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DeepComparator.class);
    private final Project myProject;
    private final GitRepositoryManager myRepositoryManager;
    private final VcsLogUi myUi;
    private final VcsLogListener myLogListener;
    private VcsLogHighlighter myHighlighter;
    private MyTask myTask;

    public static DeepComparator getInstance(Project project, VcsLogUi ui) {
        DeepComparatorHolder holder = (DeepComparatorHolder)ServiceManager.getService((Project)project, DeepComparatorHolder.class);
        return holder.getInstance(ui);
    }

    DeepComparator(Project project, GitRepositoryManager manager, VcsLogUi ui, Disposable parent) {
        this.myProject = project;
        this.myRepositoryManager = manager;
        this.myUi = ui;
        Disposer.register((Disposable)parent, (Disposable)this);
        this.myLogListener = new VcsLogListener(){

            public void onChange(VcsLogDataPack dataPack, boolean refreshHappened) {
                if (DeepComparator.this.myTask == null) {
                    return;
                }
                if (refreshHappened) {
                    String comparedBranch = DeepComparator.this.myTask.myComparedBranch;
                    Map repositoriesWithCurrentBranches = DeepComparator.this.myTask.myRepositoriesWithCurrentBranches;
                    VcsLogDataProvider provider = DeepComparator.this.myTask.myProvider;
                    DeepComparator.this.stopTask();
                    Map repositories = DeepComparator.this.getRepositories(DeepComparator.this.myUi.getDataPack().getLogProviders(), comparedBranch);
                    if (((Object)repositories).equals(repositoriesWithCurrentBranches)) {
                        DeepComparator.this.highlightInBackground(comparedBranch, provider);
                    }
                } else {
                    VcsLogBranchFilter branchFilter = DeepComparator.this.myUi.getFilterUi().getFilters().getBranchFilter();
                    if (branchFilter == null || branchFilter.getBranchNames().size() != 1 || !((String)branchFilter.getBranchNames().iterator().next()).equals(DeepComparator.this.myTask.myComparedBranch)) {
                        DeepComparator.this.stopAndUnhighlight();
                    }
                }
            }
        };
        this.myUi.addLogListener(this.myLogListener);
    }

    public void highlightInBackground(String branchToCompare, VcsLogDataProvider dataProvider) {
        if (this.myTask != null) {
            LOG.error("Shouldn't be possible");
            return;
        }
        Map<GitRepository, GitBranch> repositories = this.getRepositories(this.myUi.getDataPack().getLogProviders(), branchToCompare);
        if (repositories.isEmpty()) {
            this.removeHighlighting();
            return;
        }
        this.myTask = new MyTask(this.myProject, this.myUi, repositories, dataProvider, branchToCompare);
        this.myTask.queue();
    }

    private Map<GitRepository, GitBranch> getRepositories(Map<VirtualFile, VcsLogProvider> providers, String branchToCompare) {
        HashMap repos = ContainerUtil.newHashMap();
        for (VirtualFile root : providers.keySet()) {
            GitRepository repository = (GitRepository)this.myRepositoryManager.getRepositoryForRoot(root);
            if (repository == null || repository.getCurrentBranch() == null || repository.getBranches().findBranchByName(branchToCompare) == null) continue;
            repos.put(repository, repository.getCurrentBranch());
        }
        return repos;
    }

    public void stopAndUnhighlight() {
        this.stopTask();
        this.removeHighlighting();
    }

    private void stopTask() {
        if (this.myTask != null) {
            this.myTask.cancel();
            this.myTask = null;
        }
    }

    private void removeHighlighting() {
        if (this.myHighlighter != null) {
            this.myUi.removeHighlighter(this.myHighlighter);
        }
    }

    public void dispose() {
        this.stopAndUnhighlight();
        this.myUi.removeLogListener(this.myLogListener);
    }

    public boolean hasHighlightingOrInProgress() {
        return this.myTask != null;
    }

    private class MyTask
    extends Task.Backgroundable {
        private final Project myProject;
        private final VcsLogUi myUi;
        private final Map<GitRepository, GitBranch> myRepositoriesWithCurrentBranches;
        private final VcsLogDataProvider myProvider;
        private final String myComparedBranch;
        private final TIntHashSet myNonPickedCommits;
        private VcsException myException;
        private boolean myCancelled;

        public MyTask(Project project, VcsLogUi ui, Map<GitRepository, GitBranch> repositoriesWithCurrentBranches, VcsLogDataProvider dataProvider, String branchToCompare) {
            super(project, "Comparing branches...");
            this.myNonPickedCommits = new TIntHashSet();
            this.myProject = project;
            this.myUi = ui;
            this.myRepositoriesWithCurrentBranches = repositoriesWithCurrentBranches;
            this.myProvider = dataProvider;
            this.myComparedBranch = branchToCompare;
        }

        public void run(ProgressIndicator indicator) {
            try {
                for (Map.Entry<GitRepository, GitBranch> entry : this.myRepositoriesWithCurrentBranches.entrySet()) {
                    GitRepository repo = entry.getKey();
                    GitBranch currentBranch = entry.getValue();
                    this.myNonPickedCommits.addAll(this.getNonPickedCommitsFromGit(this.myProject, repo.getRoot(), this.myProvider, currentBranch.getName(), this.myComparedBranch).toArray());
                }
            }
            catch (VcsException e) {
                LOG.warn((Throwable)e);
                this.myException = e;
            }
        }

        public void onSuccess() {
            if (this.myCancelled) {
                return;
            }
            DeepComparator.this.removeHighlighting();
            if (this.myException != null) {
                VcsNotifier.getInstance((Project)this.myProject).notifyError("Couldn't compare with branch " + this.myComparedBranch, this.myException.getMessage());
                return;
            }
            DeepComparator.this.myHighlighter = new VcsLogHighlighter(){

                public VcsLogHighlighter.VcsCommitStyle getStyle(int commitIndex, boolean isSelected) {
                    return VcsCommitStyleFactory.foreground((Color)(!MyTask.this.myNonPickedCommits.contains(commitIndex) ? JBColor.GRAY : null));
                }
            };
            this.myUi.addHighlighter(DeepComparator.this.myHighlighter);
        }

        public void cancel() {
            this.myCancelled = true;
        }

        private TIntHashSet getNonPickedCommitsFromGit(Project project, VirtualFile root, final VcsLogDataProvider dataProvider, String currentBranch, String comparedBranch) throws VcsException {
            GitLineHandler handler = new GitLineHandler(project, root, GitCommand.CHERRY);
            handler.addParameters(currentBranch, comparedBranch);
            final TIntHashSet pickedCommits = new TIntHashSet();
            handler.addLineListener(new GitLineHandlerAdapter(){

                @Override
                public void onLineAvailable(String line, Key outputType) {
                    if (line.startsWith("+")) {
                        try {
                            line = line.substring(2).trim();
                            int firstSpace = line.indexOf(32);
                            if (firstSpace > 0) {
                                line = line.substring(0, firstSpace);
                            }
                            Hash hash = HashImpl.build((String)line);
                            pickedCommits.add(dataProvider.getCommitIndex(hash));
                        }
                        catch (Exception e) {
                            LOG.error("Couldn't parse line [" + line + "]");
                        }
                    }
                }
            });
            handler.runInCurrentThread(null);
            return pickedCommits;
        }
    }
}

