/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.actions.GitRepositoryAction;
import git4idea.commands.GitHandlerUtil;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.GitResetDialog;
import java.util.List;
import java.util.Set;

public class GitResetHead
extends GitRepositoryAction {
    @Override
    protected String getActionName() {
        return GitBundle.getString("reset.action.name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void perform(Project project, List<VirtualFile> gitRoots, VirtualFile defaultRoot, Set<VirtualFile> affectedRoots, List<VcsException> exceptions) throws VcsException {
        GitResetDialog d = new GitResetDialog(project, gitRoots, defaultRoot);
        if (!d.showAndGet()) {
            return;
        }
        GitLineHandler h = d.handler();
        affectedRoots.add(d.getGitRoot());
        AccessToken token = DvcsUtil.workingTreeChangeStarted((Project)project);
        try {
            GitHandlerUtil.doSynchronously(h, GitBundle.getString("resetting.title"), h.printableCommandLine());
        }
        finally {
            DvcsUtil.workingTreeChangeFinished((Project)project, (AccessToken)token);
        }
        GitRepositoryManager manager = GitUtil.getRepositoryManager(project);
        manager.updateRepository(d.getGitRoot());
    }
}

