/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.actions.GitRepositoryAction;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitFetcher;
import java.util.List;
import java.util.Set;

public class GitFetch
extends GitRepositoryAction {
    @Override
    protected String getActionName() {
        return GitBundle.getString("fetch.action.name");
    }

    @Override
    protected void perform(final Project project, final List<VirtualFile> gitRoots, VirtualFile defaultRoot, Set<VirtualFile> affectedRoots, List<VcsException> exceptions) throws VcsException {
        GitVcs.runInBackground(new Task.Backgroundable(project, "Fetching...", false){

            public void run(ProgressIndicator indicator) {
                GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager(project);
                new GitFetcher(project, indicator, true).fetchRootsAndNotify(GitUtil.getRepositoriesFromRoots(repositoryManager, gitRoots), null, true);
            }
        });
    }

    @Override
    protected boolean executeFinalTasksSynchronously() {
        return false;
    }
}

