/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Throwable2Computable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FilePathImpl;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFilePathUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitBinaryContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.util.GitFileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public class GitContentRevision
implements ContentRevision {
    protected final FilePath myFile;
    protected final GitRevisionNumber myRevision;
    protected final Project myProject;
    private Charset myCharset;

    protected GitContentRevision(FilePath file, GitRevisionNumber revision, Project project, Charset charset) {
        this.myProject = project;
        this.myFile = file;
        this.myRevision = revision;
        this.myCharset = charset;
    }

    public String getContent() throws VcsException {
        if (this.myFile.isDirectory()) {
            return null;
        }
        try {
            return ContentRevisionCache.getOrLoadAsString((Project)this.myProject, (FilePath)this.myFile, (VcsRevisionNumber)this.myRevision, (VcsKey)GitVcs.getKey(), (ContentRevisionCache.UniqueType)ContentRevisionCache.UniqueType.REPOSITORY_CONTENT, (Throwable2Computable)new Throwable2Computable<byte[], VcsException, IOException>(){

                public byte[] compute() throws VcsException, IOException {
                    return GitContentRevision.this.loadContent();
                }
            }, (Charset)this.myCharset);
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private byte[] loadContent() throws VcsException {
        VirtualFile root = GitUtil.getGitRoot(this.myFile);
        return GitFileUtils.getFileContent(this.myProject, root, this.myRevision.getRev(), VcsFileUtil.relativePath((VirtualFile)root, (FilePath)this.myFile));
    }

    public FilePath getFile() {
        return this.myFile;
    }

    public VcsRevisionNumber getRevisionNumber() {
        return this.myRevision;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        GitContentRevision test = (GitContentRevision)obj;
        return this.myFile.equals(test.myFile) && this.myRevision.equals(test.myRevision);
    }

    public int hashCode() {
        return this.myFile.hashCode() + this.myRevision.hashCode();
    }

    public static ContentRevision createRevision(VirtualFile vcsRoot, String path, VcsRevisionNumber revisionNumber, Project project, boolean isDeleted, boolean canBeDeleted, boolean unescapePath) throws VcsException {
        Object file = project.isDisposed() ? new FilePathImpl(new File(GitContentRevision.makeAbsolutePath(vcsRoot, path, unescapePath)), false) : GitContentRevision.createPath(vcsRoot, path, isDeleted, canBeDeleted, unescapePath);
        return GitContentRevision.createRevision(file, revisionNumber, project);
    }

    private static ContentRevision createRevision(FilePath filePath, VcsRevisionNumber revisionNumber, Project project) {
        if (revisionNumber != null && revisionNumber != VcsRevisionNumber.NULL) {
            return GitContentRevision.createRevisionImpl(filePath, (GitRevisionNumber)revisionNumber, project, null);
        }
        return CurrentContentRevision.create((FilePath)filePath);
    }

    public static ContentRevision createRevisionForTypeChange(Project project, VirtualFile vcsRoot, String path, VcsRevisionNumber revisionNumber, boolean unescapePath) throws VcsException {
        FilePath filePath;
        if (revisionNumber == null) {
            File file = new File(GitContentRevision.makeAbsolutePath(vcsRoot, path, unescapePath));
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
            filePath = virtualFile == null ? new FilePathImpl(file, false) : new FilePathImpl(virtualFile);
        } else {
            filePath = GitContentRevision.createPath(vcsRoot, path, false, false, unescapePath);
        }
        return GitContentRevision.createRevision(filePath, revisionNumber, project);
    }

    public static FilePath createPath(VirtualFile vcsRoot, String path, boolean isDeleted, boolean canBeDeleted, boolean unescapePath) throws VcsException {
        FilePath file;
        String absolutePath = GitContentRevision.makeAbsolutePath(vcsRoot, path, unescapePath);
        FilePath filePath = file = isDeleted ? VcsUtil.getFilePathForDeletedFile((String)absolutePath, (boolean)false) : VcsUtil.getFilePath((String)absolutePath, (boolean)false);
        if (canBeDeleted && !SystemInfo.isFileSystemCaseSensitive && VcsFilePathUtil.caseDiffers((String)file.getPath(), (String)absolutePath)) {
            file = FilePathImpl.createForDeletedFile((File)new File(absolutePath), (boolean)false);
        }
        return file;
    }

    private static String makeAbsolutePath(VirtualFile vcsRoot, String path, boolean unescapePath) throws VcsException {
        String unescapedPath = unescapePath ? GitUtil.unescapePath(path) : path;
        return vcsRoot.getPath() + "/" + unescapedPath;
    }

    public static ContentRevision createRevision(VirtualFile file, VcsRevisionNumber revisionNumber, Project project) {
        return GitContentRevision.createRevision(file, revisionNumber, project, null);
    }

    public static ContentRevision createRevision(VirtualFile file, VcsRevisionNumber revisionNumber, Project project, Charset charset) {
        FilePathImpl filePath = new FilePathImpl(file);
        return GitContentRevision.createRevision((FilePath)filePath, revisionNumber, project, charset);
    }

    public static ContentRevision createRevision(FilePath filePath, VcsRevisionNumber revisionNumber, Project project, Charset charset) {
        if (revisionNumber != null && revisionNumber != VcsRevisionNumber.NULL) {
            return GitContentRevision.createRevisionImpl(filePath, (GitRevisionNumber)revisionNumber, project, charset);
        }
        return CurrentContentRevision.create((FilePath)filePath);
    }

    private static GitContentRevision createRevisionImpl(FilePath path, GitRevisionNumber revisionNumber, Project project, Charset charset) {
        if (path.getFileType().isBinary()) {
            return new GitBinaryContentRevision(path, revisionNumber, project);
        }
        return new GitContentRevision(path, revisionNumber, project, charset);
    }

    public String toString() {
        return this.myFile.getPath();
    }
}

