/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import git4idea.GitReference;
import git4idea.branch.GitBranchUtil;

public abstract class GitBranch
extends GitReference {
    public static final String REFS_HEADS_PREFIX = "refs/heads/";
    public static final String REFS_REMOTES_PREFIX = "refs/remotes/";
    @Deprecated
    public static final Hash DUMMY_HASH = HashImpl.build((String)"");
    private static final Logger LOG = Logger.getInstance(GitBranch.class);
    private final Hash myHash;

    protected GitBranch(String name, Hash hash) {
        super(GitBranchUtil.stripRefsPrefix(name));
        this.myHash = hash;
    }

    public Hash getHash() {
        return this.myHash;
    }

    public abstract boolean isRemote();

    @Override
    public String getFullName() {
        return (this.isRemote() ? REFS_REMOTES_PREFIX : REFS_HEADS_PREFIX) + this.myName;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public String toLogString() {
        return String.format("%s:%s:%s", this.getFullName(), this.getHash(), this.isRemote() ? "remote" : "local");
    }
}

