/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskListener;
import com.intellij.tasks.TaskRepository;
import java.util.List;

public abstract class TaskManager {
    public static TaskManager getManager(Project project) {
        return (TaskManager)project.getComponent(TaskManager.class);
    }

    public abstract List<Task> getIssues(String var1);

    public abstract List<Task> getIssues(String var1, boolean var2);

    @Deprecated
    public List<Task> getIssues(String query, int max, long since, boolean forceRequest, boolean withClosed, ProgressIndicator cancelled) {
        throw new UnsupportedOperationException("Deprecated: should not be called");
    }

    public List<Task> getIssues(String query, int offset, int limit, boolean withClosed, ProgressIndicator indicator, boolean forceRequest) {
        return this.getIssues(query, offset + limit, 0L, forceRequest, withClosed, indicator);
    }

    public abstract List<Task> getCachedIssues();

    public abstract List<Task> getCachedIssues(boolean var1);

    public abstract Task updateIssue(String var1);

    public abstract List<LocalTask> getLocalTasks();

    public abstract List<LocalTask> getLocalTasks(boolean var1);

    public abstract LocalTask addTask(Task var1);

    public abstract LocalTask createLocalTask(String var1);

    public abstract LocalTask activateTask(Task var1, boolean var2);

    public abstract LocalTask getActiveTask();

    public abstract LocalTask findTask(String var1);

    public abstract void updateIssues(Runnable var1);

    public abstract boolean isVcsEnabled();

    public abstract AbstractVcs getActiveVcs();

    public abstract boolean isLocallyClosed(LocalTask var1);

    public abstract LocalTask getAssociatedTask(LocalChangeList var1);

    public abstract void trackContext(LocalChangeList var1);

    public abstract void disassociateFromTask(LocalChangeList var1);

    public abstract void removeTask(LocalTask var1);

    public abstract void addTaskListener(TaskListener var1);

    public abstract void removeTaskListener(TaskListener var1);

    public abstract TaskRepository[] getAllRepositories();

    public abstract boolean testConnection(TaskRepository var1);

    public static enum VcsOperation {
        CREATE_BRANCH,
        CREATE_CHANGELIST,
        DO_NOTHING;

    }
}

