/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.debugger;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.api.services.debugger.Debugger;
import com.google.gct.idea.debugger.CloudDebugProcessState;
import com.google.gct.login.CredentialedUser;
import com.google.gct.login.GoogleLogin;
import com.google.gdt.eclipse.login.common.LoginListener;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.concurrent.ConcurrentHashMap;

public class CloudDebuggerClient {
    private static final int CONNECTION_TIMEOUT_MS = 120000;
    private static final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    private static final Logger LOG = Logger.getInstance(CloudDebuggerClient.class);
    private static final String ROOT_URL = "https://www.googleapis.com";
    private static final ConcurrentHashMap<String, Debugger> myDebuggerClientsFromUserEmail = new ConcurrentHashMap();

    private CloudDebuggerClient() {
    }

    public static Debugger getCloudDebuggerClient(CloudDebugProcessState state) {
        return CloudDebuggerClient.getCloudDebuggerClient(state.getUserEmail());
    }

    public static Debugger getCloudDebuggerClient(final String userEmail) {
        if (Strings.isNullOrEmpty((String)userEmail)) {
            LOG.warn("unexpected null email in controller initialize.");
            return null;
        }
        Debugger cloudDebuggerClient = myDebuggerClientsFromUserEmail.get(userEmail);
        if (cloudDebuggerClient == null) {
            try {
                Credential credential;
                CredentialedUser user = (CredentialedUser)GoogleLogin.getInstance().getAllUsers().get(userEmail);
                Credential credential2 = credential = user != null ? user.getCredential() : null;
                if (credential != null) {
                    user.getGoogleLoginState().addLoginListener(new LoginListener(){

                        public void statusChanged(boolean login) {
                            myDebuggerClientsFromUserEmail.remove(userEmail);
                        }
                    });
                    HttpRequestInitializer initializer = new HttpRequestInitializer(){

                        public void initialize(HttpRequest httpRequest) throws IOException {
                            httpRequest.setConnectTimeout(120000);
                            httpRequest.setReadTimeout(120000);
                            credential.initialize(httpRequest);
                        }
                    };
                    NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
                    cloudDebuggerClient = new Debugger.Builder((HttpTransport)httpTransport, JSON_FACTORY, initializer).setRootUrl(ROOT_URL).setApplicationName("Android Studio").build();
                }
            }
            catch (IOException ex) {
                LOG.warn("Error connecting to Cloud Debugger API", (Throwable)ex);
            }
            catch (GeneralSecurityException ex) {
                LOG.warn("Error connecting to Cloud Debugger API", (Throwable)ex);
            }
            if (cloudDebuggerClient != null) {
                myDebuggerClientsFromUserEmail.put(userEmail, cloudDebuggerClient);
            }
        }
        return cloudDebuggerClient;
    }

    static void setClient(String userEmail, Debugger mockClient) {
        myDebuggerClientsFromUserEmail.put(userEmail, mockClient);
    }
}

