/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.gradle.notification;

import com.google.gct.idea.appengine.gradle.GradleInvoker;
import com.google.gct.idea.appengine.gradle.facet.AppEngineConfigurationProperties;
import com.google.gct.idea.appengine.gradle.facet.AppEngineGradleFacet;
import com.google.gct.idea.appengine.gradle.facet.AppEngineGradleFacetConfiguration;
import com.google.gct.idea.util.GctBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ExternalProject;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.io.File;

public class AppEngineStatusNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Logger LOG = Logger.getInstance(AppEngineStatusNotificationProvider.class);
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"appengine.sdk.status");
    private final Project myProject;

    public AppEngineStatusNotificationProvider(Project project) {
        this.myProject = project;
    }

    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    public EditorNotificationPanel createNotificationPanel(VirtualFile file, FileEditor fileEditor) {
        AppEngineConfigurationProperties state;
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)this.myProject);
        if (module == null) {
            return null;
        }
        AppEngineGradleFacet facet = AppEngineGradleFacet.getInstance(module);
        if (facet != null && (state = ((AppEngineGradleFacetConfiguration)facet.getConfiguration()).getState()) != null && !new File(state.APPENGINE_SDKROOT).exists()) {
            return new DownloadSdkNotification(module);
        }
        return null;
    }

    private class DownloadSdkNotification
    extends EditorNotificationPanel {
        DownloadSdkNotification(final Module module) {
            this.setText(GctBundle.message("appengine.sdk.invalid", module.getName()));
            this.createActionLabel(GctBundle.message("appengine.sdk.gradle.install", new Object[0]), new Runnable(){

                @Override
                public void run() {
                    GradleInvoker.executeTask(":appengineDownloadSdk", module, new TaskCallback(){

                        public void onSuccess() {
                            ExternalProject gradleProject = GradleInvoker.getGradleModelItem(module);
                            if (gradleProject != null) {
                                File buildFile = gradleProject.getBuildFile();
                                if (buildFile == null) {
                                    LOG.warn("could not locate gradle build file to open.");
                                    return;
                                }
                                final VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(buildFile);
                                if (virtualFile != null && virtualFile.exists()) {
                                    DownloadSdkNotification.this.createActionLabel(GctBundle.message("appengine.sdk.open.gradle.build", new Object[0]), new Runnable(){

                                        @Override
                                        public void run() {
                                            FileEditorManager.getInstance((Project)AppEngineStatusNotificationProvider.this.myProject).openFile(virtualFile, true);
                                        }
                                    });
                                }
                            }
                        }

                        public void onFailure() {
                            LOG.warn("unable to download appengine sdk.");
                        }
                    }, ProgressExecutionMode.IN_BACKGROUND_ASYNC);
                }
            });
        }
    }
}

