/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.idea.appengine.gradle.facet;

import com.google.common.base.Strings;
import com.google.gct.idea.appengine.dom.AppEngineWebApp;
import com.google.gct.idea.appengine.dom.WebApp;
import com.google.gct.idea.appengine.gradle.facet.AppEngineConfigurationProperties;
import com.google.gct.idea.appengine.gradle.facet.AppEngineGradleFacetConfiguration;
import com.google.gct.idea.appengine.sdk.AppEngineSdk;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import java.io.File;

public class AppEngineGradleFacet
extends Facet<AppEngineGradleFacetConfiguration> {
    private static final Logger LOG = Logger.getInstance(AppEngineGradleFacet.class);
    public static final String ID = "app-engine-gradle";
    public static final String NAME = "App Engine Gradle";
    public static final FacetTypeId<AppEngineGradleFacet> TYPE_ID = new FacetTypeId("app-engine-gradle");

    public static AppEngineGradleFacet getInstance(Module module) {
        return (AppEngineGradleFacet)FacetManager.getInstance((Module)module).getFacetByType(TYPE_ID);
    }

    public AppEngineGradleFacet(FacetType facetType, Module module, String name, AppEngineGradleFacetConfiguration configuration) {
        super(facetType, module, name, (FacetConfiguration)configuration, null);
    }

    public AppEngineWebApp getAppEngineWebXml() {
        XmlFile appEngineXmlFile = this.getAppEngineXmlFile("appengine-web.xml");
        DomManager domManager = DomManager.getDomManager((Project)this.getModule().getProject());
        return (AppEngineWebApp)domManager.getFileElement(appEngineXmlFile, AppEngineWebApp.class).getRootElement();
    }

    public AppEngineSdk getAppEngineSdk() {
        AppEngineConfigurationProperties state = ((AppEngineGradleFacetConfiguration)this.getConfiguration()).getState();
        if (state != null) {
            String sdkRoot = state.APPENGINE_SDKROOT;
            return new AppEngineSdk(sdkRoot);
        }
        return null;
    }

    private XmlFile getAppEngineXmlFile(String fileName) {
        AppEngineConfigurationProperties model = ((AppEngineGradleFacetConfiguration)this.getConfiguration()).getState();
        if (model == null || Strings.isNullOrEmpty((String)model.WEB_APP_DIR)) {
            return null;
        }
        String path = model.WEB_APP_DIR + "/WEB-INF/" + fileName;
        VirtualFile appEngineFile = LocalFileSystem.getInstance().findFileByPath(path.replace(File.separatorChar, '/'));
        if (appEngineFile == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.getModule().getProject()).findFile(appEngineFile);
        if (psiFile == null || !(psiFile instanceof XmlFile)) {
            return null;
        }
        return (XmlFile)psiFile;
    }

    public WebApp getWebXml() {
        XmlFile webXmlFile = this.getAppEngineXmlFile("web.xml");
        return this.getDomElement(webXmlFile, WebApp.class);
    }

    public WebApp getWebXmlForEdit() {
        XmlFile webXmlFile = this.getAppEngineXmlFile("web.xml");
        ReadonlyStatusHandler.getInstance((Project)this.getModule().getProject()).ensureFilesWritable(new VirtualFile[]{webXmlFile.getVirtualFile()});
        return this.getDomElement(webXmlFile, WebApp.class);
    }

    private <T extends DomElement> T getDomElement(XmlFile xmlFile, Class<T> domClass) {
        DomManager domManager = DomManager.getDomManager((Project)this.getModule().getProject());
        return (T)domManager.getFileElement(xmlFile, domClass).getRootElement();
    }

    public static FacetType<AppEngineGradleFacet, AppEngineGradleFacetConfiguration> getFacetType() {
        return FacetTypeRegistry.getInstance().findFacetType(ID);
    }

    public static AppEngineGradleFacet getAppEngineFacetByModule(Module module) {
        if (module == null) {
            return null;
        }
        return (AppEngineGradleFacet)FacetManager.getInstance((Module)module).getFacetByType(TYPE_ID);
    }
}

