/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.SyncService;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.devices.Abi;
import com.android.tools.idea.run.AndroidRunningState;
import com.android.tools.idea.run.ErrorMatchingReceiver;
import com.android.tools.ndk.ModulePathManager;
import com.android.tools.ndk.run.AndroidNativeDebugProcess;
import com.android.tools.ndk.run.AndroidNativeRunConfiguration;
import com.android.tools.ndk.run.ClientShellHelper;
import com.android.tools.ndk.run.DebuggerContext;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriverConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.android.util.AndroidOutputReceiver;

public class AndroidLLDBDebuggerContext
extends DebuggerContext {
    private static final String LLDB_SERVER_START_SCRIPT = "start_lldb_server.sh";
    private static final String LLDB_SERVER = "lldb-server";
    private static final String DEVICE_TEMP_PATH = "/data/local/tmp";
    private static final Map<Abi, Abi> ABI_MAPPINGS = Collections.singletonMap(Abi.ARMEABI_V7A, Abi.ARMEABI);
    private String myPlatformDomainSocketPath;
    private static final Logger LOG = Logger.getInstance(AndroidLLDBDebuggerContext.class);

    @Override
    public DebuggerDriverConfiguration getDebuggerDriverConfiguration(AndroidRunningState androidRunningState, IDevice device) {
        return new AndroidLLDBDriverConfiguration(androidRunningState, device, this.myPlatformDomainSocketPath, null);
    }

    @Override
    public void startServer(AndroidRunningState state, Client client, AtomicBoolean cancelled) throws DebuggerContext.StartServerException {
        try {
            this.launchLLDBServer(state, client, cancelled);
        }
        catch (Exception e) {
            throw new DebuggerContext.StartServerException(e);
        }
    }

    private void launchLLDBServer(AndroidRunningState state, Client client, final AtomicBoolean cancelled) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException, ShellCommandUnresponsiveException {
        final IDevice device = client.getDevice();
        AndroidNativeRunConfiguration configuration = (AndroidNativeRunConfiguration)state.getConfiguration();
        File lldbServer = AndroidLLDBDebuggerContext.findLLDBServer(state, device);
        if (lldbServer == null) {
            LOG.error("LLDB server not found");
            throw new IllegalStateException("LLDB server not found");
        }
        ClientShellHelper clientShell = new ClientShellHelper(client, state.getPackageName());
        String packageLLDBDir = clientShell.getPackageFolder() + "/lldb";
        String packageLLDBBinDir = packageLLDBDir + "/bin";
        this.getAttachProgressReporter().step("Creating device directories");
        LOG.info("Creating LLDB bin directory " + packageLLDBBinDir);
        ErrorMatchingReceiver receiver = new ErrorMatchingReceiver(state.getStoppedRef());
        state.executeDeviceCommandAndWriteToConsole(device, clientShell.runAs("mkdir " + packageLLDBDir), (AndroidOutputReceiver)receiver);
        String runAsBrokenMessage = String.format("run-as: Package '%s' is unknown", state.getPackageName());
        if (receiver.getOutput().toString().startsWith(runAsBrokenMessage)) {
            String errorMessage = "run-as is broken (please see http://b.android.com/187955 for details)";
            LOG.error("run-as is broken (please see http://b.android.com/187955 for details)");
            throw new IllegalStateException("run-as is broken (please see http://b.android.com/187955 for details)");
        }
        state.executeDeviceCommandAndWriteToConsole(device, clientShell.runAs("mkdir " + packageLLDBBinDir), (AndroidOutputReceiver)new ErrorMatchingReceiver(state.getStoppedRef()));
        LOG.info("Pushing LLDB files to the device");
        this.getAttachProgressReporter().step("Pushing binaries to the device");
        this.pushDebuggerFile(state, device, clientShell, lldbServer, packageLLDBBinDir);
        File startLLLDBServerScript = ModulePathManager.getAndroidLLDBBinFile(LLDB_SERVER_START_SCRIPT);
        String startScriptPath = this.pushDebuggerFile(state, device, clientShell, startLLLDBServerScript, packageLLDBBinDir);
        this.myPlatformDomainSocketPath = String.format("%s/tmp/platform-%d.sock", packageLLDBDir, System.currentTimeMillis());
        final String startCmd = clientShell.runAs(String.format("%s %s %s \"%s\"", startScriptPath, packageLLDBDir, this.myPlatformDomainSocketPath, configuration.getTargetLoggingChannels()));
        LOG.info("Starting LLDB server: " + startCmd);
        this.getAttachProgressReporter().step("Starting LLDB server");
        state.getPrinter().stdout("Starting LLDB server: " + startCmd);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                try {
                    ErrorMatchingReceiver receiver = new ErrorMatchingReceiver(cancelled);
                    device.executeShellCommand(startCmd, (IShellOutputReceiver)receiver, 0L, TimeUnit.DAYS);
                    LOG.info("LLDB server has exited: " + receiver.getOutput());
                }
                catch (Exception e) {
                    LOG.error("LLDB server has failed: ", (Throwable)e);
                }
            }
        });
    }

    private static File getAndroidLLDBBinFile(Abi abi) {
        return ModulePathManager.getAndroidLLDBBinFile(new File(abi.toString(), LLDB_SERVER).getPath());
    }

    private static File findLLDBServer(AndroidRunningState state, IDevice device) {
        Abi abi;
        File lldbServerFile;
        List abis = device.getAbis();
        for (String abiStr : abis) {
            File lldbServerFile2;
            Abi abi2 = Abi.getEnum((String)abiStr);
            if (abi2 == null) {
                LOG.error("Failed to get abi by name: " + abiStr);
                continue;
            }
            if (AndroidNativeDebugProcess.getSymbolsDir(state, Collections.singletonList(abi2)).isEmpty() || (lldbServerFile2 = AndroidLLDBDebuggerContext.getServerFileByAbi(abi2)) == null) continue;
            return lldbServerFile2;
        }
        if (!abis.isEmpty() && (lldbServerFile = AndroidLLDBDebuggerContext.getServerFileByAbi(abi = Abi.getEnum((String)((String)abis.get(0))))) != null) {
            return lldbServerFile;
        }
        return null;
    }

    private static File getServerFileByAbi(Abi abi) {
        File lldbServerFile = AndroidLLDBDebuggerContext.getAndroidLLDBBinFile(abi);
        if (lldbServerFile.exists()) {
            return lldbServerFile;
        }
        Abi mappedAbi = ABI_MAPPINGS.get(abi);
        if (mappedAbi != null && (lldbServerFile = AndroidLLDBDebuggerContext.getAndroidLLDBBinFile(mappedAbi)).exists()) {
            return lldbServerFile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SyncService.FileStat statRemoteFile(IDevice device, String remoteFile) throws TimeoutException, AdbCommandRejectedException, IOException {
        SyncService sync = null;
        try {
            sync = device.getSyncService();
            if (sync != null) {
                SyncService.FileStat fileStat = sync.statFile(remoteFile);
                return fileStat;
            }
            LOG.error("Failed to get SyncService");
        }
        finally {
            if (sync != null) {
                sync.close();
            }
        }
        return null;
    }

    private String pushDebuggerFile(AndroidRunningState state, IDevice device, ClientShellHelper clientShell, File localFile, String destDir) throws IOException, AdbCommandRejectedException, TimeoutException, SyncException, ShellCommandUnresponsiveException {
        String fileName = localFile.getName();
        String destFile = destDir + "/" + fileName;
        String tmpDestFile = "/data/local/tmp/" + fileName;
        Date localFileLmt = new Date(localFile.lastModified() / 1000L * 1000L);
        SyncService.FileStat destFileStat = AndroidLLDBDebuggerContext.statRemoteFile(device, tmpDestFile);
        if (destFileStat == null || destFileStat.getMode() == 0 || !localFileLmt.equals(destFileStat.getLastModified()) || localFile.length() != (long)destFileStat.getSize()) {
            LOG.info("Pushing to the device: " + localFile + " => " + tmpDestFile);
            device.pushFile(localFile.getAbsolutePath(), tmpDestFile);
        } else {
            LOG.info("Remote file " + tmpDestFile + " is up-to-date.");
        }
        ErrorMatchingReceiver receiver = new ErrorMatchingReceiver(state.getStoppedRef());
        String copyChmodCommand = "cat " + tmpDestFile + " | " + clientShell.runAs(String.format("sh -c 'cat > %s; chmod 700 %s'", destFile, destFile));
        LOG.info("Copying to app folder: " + tmpDestFile + " => " + destFile);
        LOG.info("Command: " + copyChmodCommand);
        state.executeDeviceCommandAndWriteToConsole(device, copyChmodCommand, (AndroidOutputReceiver)receiver);
        if (receiver.hasError()) {
            throw new IOException("Command failed: " + copyChmodCommand);
        }
        return destFile;
    }
}

