/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.crash;

import com.android.tools.idea.diagnostics.error.ErrorReportCustomizer;
import com.android.tools.ndk.run.crash.NativeClientCrashReportingTask;
import com.google.common.io.Files;
import com.intellij.diagnostic.LogEventException;
import com.intellij.diagnostic.LogMessage;
import com.intellij.errorreport.bean.ErrorBean;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.IdeaLoggingEvent;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;

public class NativeClientCrashException
extends Exception {
    private static final char[] hexChars = "0123456789abcdef".toCharArray();

    public static LogEventException create(String message, File minidump) throws IOException {
        return new LogEventException((IdeaLoggingEvent)new LoggingEvent(message, minidump));
    }

    private static Attachment createMinidumpAttachment(File minidump) throws IOException {
        String filename = minidump.getAbsolutePath();
        byte[] contents = Files.toByteArray((File)minidump);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < contents.length; i += 16) {
            int j;
            for (j = 0; j < 16; ++j) {
                if (i + j < contents.length) {
                    sb.append(hexChars[contents[i + j] >> 4 & 0xF]);
                    sb.append(hexChars[contents[i + j] & 0xF]);
                } else {
                    sb.append("  ");
                }
                sb.append(" ");
                if (j != 7) continue;
                sb.append("  ");
            }
            sb.append("  |");
            for (j = 0; j < 16 && i + j < contents.length; ++j) {
                Byte b = contents[i + j];
                if (b > 32 && b < 127) {
                    sb.appendCodePoint(b.byteValue());
                    continue;
                }
                sb.append('.');
            }
            sb.append("|\n");
        }
        return new Attachment(filename, contents, sb.toString());
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        s.append("\nTechnical details are in the attachment.");
    }

    private static class CrashData
    extends LogMessage
    implements ErrorReportCustomizer {
        private final Attachment myAttachment;

        public CrashData(IdeaLoggingEvent aEvent, Attachment attachment) {
            super(aEvent);
            this.myAttachment = attachment;
        }

        public List<Attachment> getAttachments() {
            return Arrays.asList(this.myAttachment);
        }

        public Task.Backgroundable makeReportingTask(Project project, String title, boolean canBeCancelled, ErrorBean bean, Consumer<String> callback, Consumer<Exception> errorCallback) {
            return new NativeClientCrashReportingTask(project, title, canBeCancelled, bean, callback, errorCallback);
        }
    }

    private static class LoggingEvent
    extends IdeaLoggingEvent {
        private final Attachment myAttachment;

        public LoggingEvent(String message, File minidump) throws IOException {
            super(message, (Throwable)new NativeClientCrashException());
            this.myAttachment = NativeClientCrashException.createMinidumpAttachment(minidump);
        }

        public Object getData() {
            return new CrashData(this, this.myAttachment);
        }
    }
}

