/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.crash;

import com.android.tools.ndk.run.crash.NativeClientCrashException;
import com.android.tools.ndk.run.lldb.AndroidLLDBDriver;
import com.google.common.io.PatternFilenameFilter;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Map;

public class AndroidLLDBBreakpadIntegration {
    private static final Logger LOG = Logger.getInstance(AndroidLLDBBreakpadIntegration.class);
    private static final Object MINIDUMP_MUTEX = new Object();
    private static final boolean ENABLE_CRASH_DUMPS = false;

    private static File getMinidumpDir() {
        File folder = new File(PathManager.getTempPath(), "lldb");
        if (folder.exists() ? !folder.isDirectory() : !folder.mkdir()) {
            return null;
        }
        return folder;
    }

    private static int checkForMinidumps(String message) {
        File dir = AndroidLLDBBreakpadIntegration.getMinidumpDir();
        if (dir == null) {
            return 0;
        }
        File[] minidumps = dir.listFiles((FilenameFilter)new PatternFilenameFilter(".*\\.dmp"));
        int count = 0;
        for (File minidump : minidumps) {
            try {
                LOG.error((Throwable)NativeClientCrashException.create(message, minidump));
                ++count;
            }
            catch (IOException e) {
                LOG.error("Error reading native client crash dump.", (Throwable)e);
            }
            minidump.delete();
        }
        return count;
    }

    public static void setUpRunEnvironment(Map<String, String> env) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkForStaleMinidumps() {
        Object object = MINIDUMP_MUTEX;
        synchronized (object) {
            return AndroidLLDBBreakpadIntegration.checkForMinidumps("Previous native debug session crashed") > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkForCrashes(AndroidLLDBDriver driver) {
        Object object = MINIDUMP_MUTEX;
        synchronized (object) {
            if (AndroidLLDBBreakpadIntegration.checkForMinidumps("Native debugging client crashed") > 0) {
                driver.setCrashed(true);
            }
            return driver.isCrashed();
        }
    }

    public static void monitorForCrashes(final AndroidLLDBDriver driver) {
        driver.getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                AndroidLLDBBreakpadIntegration.checkForCrashes(driver);
            }
        });
    }
}

