/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni;

import com.android.tools.ndk.jni.JniNameMangler;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import java.util.ArrayList;
import org.jetbrains.android.facet.AndroidFacet;

public class JniGotoDeclarationHandler
implements GotoDeclarationHandler {
    public PsiElement[] getGotoDeclarationTargets(PsiElement sourceElement, int offset, Editor editor) {
        return JniGotoDeclarationHandler.getGotoDeclarationTargets(sourceElement);
    }

    public static PsiElement[] getGotoDeclarationTargets(PsiElement sourceElement) {
        if (sourceElement instanceof PsiIdentifier) {
            return JniGotoDeclarationHandler.findNativeDeclarationTargets((PsiIdentifier)sourceElement);
        }
        if (sourceElement instanceof PsiKeyword) {
            PsiKeyword keyword = (PsiKeyword)sourceElement;
            if (keyword.getTokenType() == JavaTokenType.NATIVE_KEYWORD) {
                return JniGotoDeclarationHandler.findNativeDeclarationTargets(keyword);
            }
        } else if (sourceElement instanceof PsiMethod) {
            return JniGotoDeclarationHandler.findNativeDeclarationTargets((PsiMethod)sourceElement);
        }
        return null;
    }

    private static PsiElement[] findNativeDeclarationTargets(PsiKeyword nativeKeyword) {
        assert (nativeKeyword.getTokenType() == JavaTokenType.NATIVE_KEYWORD) : nativeKeyword;
        if (nativeKeyword.getParent() instanceof PsiModifierList && nativeKeyword.getParent().getParent() instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)nativeKeyword.getParent().getParent();
            return JniGotoDeclarationHandler.findNativeDeclarationTargets(method);
        }
        return null;
    }

    private static PsiElement[] findNativeDeclarationTargets(PsiIdentifier identifier) {
        PsiMethod method;
        if (identifier.getParent() instanceof PsiMethod && (method = (PsiMethod)identifier.getParent()).getModifierList().hasExplicitModifier("native")) {
            return JniGotoDeclarationHandler.findNativeDeclarationTargets(method);
        }
        return null;
    }

    private static PsiElement[] findNativeDeclarationTargets(PsiMethod method) {
        PsiFile file = method.getContainingFile();
        if (file == null) {
            return null;
        }
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file);
        if (facet == null) {
            return null;
        }
        Project project = facet.getModule().getProject();
        final ArrayList elements = Lists.newArrayList();
        Processor<OCSymbol> processor = new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                PsiElement definition;
                if ((symbol.getKind() == OCSymbolKind.FUNCTION_DECLARATION || symbol.getKind() == OCSymbolKind.FUNCTION_PREDECLARATION) && (definition = symbol.locateDefinition()) != null) {
                    elements.add(definition);
                }
                return true;
            }
        };
        String signature = JniNameMangler.getJniMethodName(method, false);
        OCGlobalProjectSymbolsCache.processByQualifiedName((Project)project, (Processor)processor, (String)signature);
        if (elements.isEmpty()) {
            signature = JniNameMangler.getJniMethodName(method, true);
            OCGlobalProjectSymbolsCache.processByQualifiedName((Project)project, (Processor)processor, (String)signature);
        }
        return !elements.isEmpty() ? elements.toArray(new PsiElement[elements.size()]) : null;
    }

    public String getActionText(DataContext context) {
        return null;
    }
}

