/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.documentation;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.documentation.CidrDocumentationProvider;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DoxygenDocumentationProvider
extends CidrDocumentationProvider {
    static final String HTML_INDENT = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    private static final Pattern structuralTagsPattern = Pattern.compile("(\\\\|@)(attention|authors?|bug|copyright|date|deprecated|exception|invariant|param|pre|post|remarks?|result|returns?|retval|sa|see|since|throws?|todo|version|warning)");
    private static final Map<String, String> tagDescriptions;
    private static final Map<String, String> sameMeaningTags;
    private static final Map<String, String> visualCommands;

    protected void addMacroDoc(PsiElement originalElement, StringBuilder answer, OCDefineDirective define) {
        PsiElement macroDefinition;
        super.addMacroDoc(originalElement, answer, define);
        if (originalElement != null && (macroDefinition = originalElement.getParent()) != null) {
            answer.append("<b>Documentation:</b>");
            this.addCommentDoc(macroDefinition, answer);
        }
    }

    protected void addCommentDoc(PsiElement element, StringBuilder answer) {
        OCStruct struct;
        PsiElement parent;
        PsiComment comment = DoxygenDocumentationProvider.findCommentFor(element);
        if (comment == null && element instanceof OCStruct && (parent = (struct = (OCStruct)element).getParent()) != null && parent instanceof OCTypeElement) {
            comment = DoxygenDocumentationProvider.findCommentFor(parent);
        }
        if (comment == null && element instanceof OCSymbolDeclarator) {
            PsiElement associatedElement;
            OCSymbol symbol = ((OCSymbolDeclarator)element).getSymbol();
            if (symbol != null) {
                symbol = symbol.getAssociatedSymbol();
            }
            if (symbol != null && (associatedElement = symbol.locateDefinition()) != null) {
                comment = DoxygenDocumentationProvider.findCommentFor(associatedElement);
            }
        }
        if (comment != null) {
            PsiComment briefComment = DoxygenDocumentationProvider.getBriefComment(comment = DoxygenDocumentationProvider.getFirstComment(comment));
            if (briefComment != null) {
                DoxygenDocumentationProvider.addAllComments(briefComment, answer);
            }
            DoxygenDocumentationProvider.addAllComments(comment, answer);
        }
    }

    private static PsiComment findCommentFor(PsiElement elt) {
        if (elt instanceof OCDeclarator) {
            elt = elt.getParent();
        }
        if (elt == null) {
            return null;
        }
        if (elt.getParent() instanceof OCProperty) {
            elt = elt.getParent();
        }
        if (elt.getContainingFile() == null) {
            return null;
        }
        PsiElement child = elt.getFirstChild();
        if (child instanceof PsiComment) {
            return (PsiComment)child;
        }
        for (elt = elt.getPrevSibling(); elt != null; elt = elt.getPrevSibling()) {
            PsiElement prev;
            if (elt instanceof PsiComment && ((prev = elt.getPrevSibling()) == null || prev instanceof PsiComment || prev instanceof PsiWhiteSpace && prev.getText().contains("\n"))) {
                return (PsiComment)elt;
            }
            if (elt.getTextLength() <= 0) continue;
            IElementType type = OCElementUtil.getObjCKeywordElementType((ASTNode)elt.getNode());
            if (!(elt instanceof PsiWhiteSpace) && type != OCTokenTypes.OPTIONAL_KEYWORD && type != OCTokenTypes.REQUIRED_KEYWORD) break;
        }
        return null;
    }

    private static PsiComment getFirstComment(PsiComment comment) {
        PsiComment prev;
        while ((prev = DoxygenDocumentationProvider.getPreviousComment((PsiElement)comment)) != null) {
            comment = prev;
        }
        return comment;
    }

    private static PsiComment getPreviousComment(PsiElement element) {
        PsiWhiteSpace w;
        PsiElement wPrev;
        PsiElement prev = element.getPrevSibling();
        if (prev instanceof PsiComment) {
            return (PsiComment)prev;
        }
        if (prev instanceof PsiWhiteSpace && (wPrev = (w = (PsiWhiteSpace)prev).getPrevSibling()) instanceof PsiComment) {
            PsiComment prevComment = (PsiComment)wPrev;
            PsiElement prevCommentPrecedingWS = prevComment.getPrevSibling();
            PsiElement prevCommentParent = prevComment.getParent();
            if (prevCommentPrecedingWS instanceof PsiWhiteSpace && prevCommentPrecedingWS.getText().contains("\n") || !(prevCommentParent instanceof OCFile) || prevCommentPrecedingWS != null) {
                return prevComment;
            }
        }
        return null;
    }

    private static PsiComment getBriefComment(PsiComment comment) {
        PsiElement parent = comment.getParent();
        PsiComment prev = DoxygenDocumentationProvider.getPreviousComment(parent);
        if (prev == null) {
            return null;
        }
        return DoxygenDocumentationProvider.getFirstComment(prev);
    }

    private static void addAllComments(PsiComment comment, StringBuilder answer) {
        boolean startWithDashStar = false;
        boolean startWithDashDash = false;
        boolean newParagraph = true;
        boolean newTagGroup = false;
        String tagUnderGrouping = null;
        while (true) {
            PsiComment nextComment;
            PsiElement nextCommentAfterWS;
            PsiWhiteSpace w;
            PsiElement wNext;
            String text;
            if ((text = comment.getText()).startsWith("/*")) {
                if ((text = text.substring(2)).startsWith("*") || text.startsWith("!")) {
                    text = text.substring(1);
                }
                if (text.endsWith("*/")) {
                    text = text.substring(0, text.length() - 2);
                }
                startWithDashStar = true;
            } else if (text.startsWith("//")) {
                if ((text = text.substring(2)).startsWith("/") || text.startsWith("!")) {
                    text = text.substring(1);
                }
                startWithDashDash = true;
            }
            text = text.trim();
            text = text.replaceAll("(\\\\|@)brief", "\n\n");
            text = text.replaceAll("(\\\\|@)short", "\n\n");
            text = text.replaceAll("(\\\\|@)details", "\n\n");
            text = text.trim();
            for (Map.Entry<String, String> entry : visualCommands.entrySet()) {
                String doxygenTag = entry.getKey();
                String htmlTag = entry.getValue();
                String regEx = "(\\s)(\\\\|@)(" + doxygenTag + ")(\\s)(\\S+)(\\s)";
                String replacement = "$1<" + htmlTag + ">$5</" + htmlTag + ">$6";
                text = text.replaceAll(regEx, replacement);
            }
            text = text.replaceAll("(\\\\|@)n", "<br>");
            text = text.trim();
            for (String line : StringUtil.splitByLines((String)text, (boolean)false)) {
                int lineLength;
                line = line.trim();
                if (startWithDashStar && line.startsWith("*")) {
                    line = line.substring(1);
                }
                if ((lineLength = (line = line.trim()).length()) == 0 || startWithDashStar && StringUtil.countChars((CharSequence)line, (char)'*') == lineLength || startWithDashDash && StringUtil.countChars((CharSequence)line, (char)'/') == lineLength) {
                    newParagraph = true;
                    continue;
                }
                Matcher matcher = structuralTagsPattern.matcher(line);
                HashSet lineTags = Sets.newHashSet();
                while (matcher.find()) {
                    String a = matcher.group(2);
                    if (!lineTags.add("@" + a)) continue;
                    line = line.replaceAll("(\\\\|@)" + a, "\n@" + a);
                }
                line = line.trim();
                for (String subLine : StringUtil.splitByLines((String)line, (boolean)false)) {
                    String lineTag = null;
                    for (String tag : lineTags) {
                        if (!subLine.startsWith(tag)) continue;
                        lineTag = tag;
                        subLine = subLine.replace(lineTag, HTML_INDENT);
                        if (!sameMeaningTags.containsKey(lineTag)) break;
                        lineTag = sameMeaningTags.get(lineTag);
                        break;
                    }
                    if (lineTag != null) {
                        if (!lineTag.equals(tagUnderGrouping)) {
                            tagUnderGrouping = lineTag;
                            newTagGroup = true;
                        }
                    } else if (newParagraph) {
                        tagUnderGrouping = null;
                    }
                    if (answer.length() > 0) {
                        if (newTagGroup) {
                            answer.append("<br><br><b>").append(tagDescriptions.get(tagUnderGrouping)).append("</b><br><br>");
                        } else if (newParagraph && tagUnderGrouping == null) {
                            answer.append("<br><br>");
                        } else if (lineTag != null) {
                            answer.append("<br>");
                        } else {
                            answer.append(' ');
                        }
                    }
                    answer.append(subLine);
                    newParagraph = false;
                    newTagGroup = false;
                }
            }
            PsiElement next = comment.getNextSibling();
            if (next instanceof PsiComment) {
                comment = (PsiComment)next;
                continue;
            }
            if (!(next instanceof PsiWhiteSpace) || !((wNext = (w = (PsiWhiteSpace)next).getNextSibling()) instanceof PsiComment) || !((nextCommentAfterWS = (nextComment = (PsiComment)wNext).getNextSibling()) instanceof PsiWhiteSpace) || !nextCommentAfterWS.getText().contains("\n")) break;
            comment = nextComment;
        }
    }

    static {
        ImmutableMap.Builder tagDescriptionsBuilder = ImmutableMap.builder();
        tagDescriptions = tagDescriptionsBuilder.put((Object)"@attention", (Object)"Attention").put((Object)"@authors", (Object)"Authors").put((Object)"@bug", (Object)"Bug").put((Object)"@copyright", (Object)"Copyright").put((Object)"@date", (Object)"Date").put((Object)"@deprecated", (Object)"Deprecated").put((Object)"@exception", (Object)"Exceptions").put((Object)"@invariant", (Object)"Invariant").put((Object)"@param", (Object)"Parameters").put((Object)"@pre", (Object)"Precondition").put((Object)"@post", (Object)"Postcondition").put((Object)"@remarks", (Object)"Remarks").put((Object)"@returns", (Object)"Returns").put((Object)"@retval", (Object)"Return values").put((Object)"@return", (Object)"Returns").put((Object)"@sa", (Object)"See also").put((Object)"@since", (Object)"Since").put((Object)"@todo", (Object)"Todo").put((Object)"@version", (Object)"Version").put((Object)"@warning", (Object)"Warning").build();
        ImmutableMap.Builder sameMeaningTagsBuilder = ImmutableMap.builder();
        sameMeaningTags = sameMeaningTagsBuilder.put((Object)"@author", (Object)"@authors").put((Object)"@remark", (Object)"@remarks").put((Object)"@result", (Object)"@returns").put((Object)"@return", (Object)"@returns").put((Object)"@see", (Object)"@sa").put((Object)"@throw", (Object)"@exception").put((Object)"@throws", (Object)"@exception").build();
        ImmutableMap.Builder visualCommandsBuilder = ImmutableMap.builder();
        visualCommands = visualCommandsBuilder.put((Object)"a", (Object)"em").put((Object)"b", (Object)"b").put((Object)"c", (Object)"tt").put((Object)"e", (Object)"em").put((Object)"em", (Object)"em").put((Object)"p", (Object)"tt").build();
    }
}

