/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.compiler.CidrCompilerResult;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerSettings;
import com.jetbrains.cidr.toolchains.CompilerInfoCache;
import java.util.List;
import java.util.Map;

public class NdkCompilerInfoCache {
    private final CompilerInfoCache myCompilerInfoCache = new CompilerInfoCache();

    public NdkCompilerInfo getCompilerInfo(Project project, OCCompilerSettings compilerSettings, OCLanguageKind lang, VirtualFile sourceFile) throws NdkCompilerInvocationException {
        CidrCompilerResult compilerResult = this.myCompilerInfoCache.getCompilerInfoCache(project, compilerSettings, lang, sourceFile);
        CompilerInfoCache.Entry compilerInfo = (CompilerInfoCache.Entry)compilerResult.getResult();
        if (compilerInfo == null) {
            Throwable error = compilerResult.getError();
            if (error != null) {
                throw new NdkCompilerInvocationException(error);
            }
            throw new NdkCompilerInvocationException("Failed to get the compiler information for file " + sourceFile.getPath());
        }
        return new NdkCompilerInfo(compilerInfo);
    }

    public static class NdkCompilerInvocationException
    extends Exception {
        private NdkCompilerInvocationException(String message) {
            super(message);
        }

        private NdkCompilerInvocationException(Throwable cause) {
            super(cause);
        }
    }

    public static class NdkCompilerInfo {
        private final CompilerInfoCache.Entry myInfo;

        private NdkCompilerInfo(CompilerInfoCache.Entry info) {
            this.myInfo = info;
        }

        public String getDefines() {
            return this.myInfo.defines;
        }

        public Map<String, String> getFeatures() {
            return this.myInfo.features;
        }

        public Map<String, String> getExtensions() {
            return this.myInfo.extensions;
        }

        public List<PsiFileSystemItem> getHeaderSearchPaths() {
            return this.myInfo.headerSearchPaths;
        }
    }
}

