/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.android.builder.model.NativeLibrary;
import com.android.builder.model.NativeToolchain;
import com.android.tools.ndk.NdkCompilerInfoCache;
import com.google.common.collect.Lists;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCImportsGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.toolchains.DefaultCidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerMacros;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeaderRoots;
import com.jetbrains.cidr.lang.workspace.headerRoots.IncludedHeadersRoot;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ModuleResolveConfiguration
extends UserDataHolderBase
implements OCResolveConfiguration {
    private static final NotificationGroup EVENT_LOG_NOTIFICATION = NotificationGroup.logOnlyGroup((String)"NDK Compile");
    private static final Logger LOG = Logger.getInstance(ModuleResolveConfiguration.class);
    private final Project myProject;
    private final NativeLibrary myNativeLibrary;
    private final NativeToolchain myNativeToolchain;
    private final NdkCompilerInfoCache myCompilerInfoCache;
    private final CompilerSettings myCompilerSettings;
    private final OCCompilerMacros myCompilerMacros;

    ModuleResolveConfiguration(Project project, File compilerWorkingDir, NdkCompilerInfoCache compilerInfoCache, NativeLibrary nativeLibrary, NativeToolchain nativeToolchain) {
        this.myProject = project;
        this.myNativeLibrary = nativeLibrary;
        this.myNativeToolchain = nativeToolchain;
        this.myCompilerInfoCache = compilerInfoCache;
        this.myCompilerSettings = new CompilerSettings(compilerWorkingDir);
        this.myCompilerMacros = new CompilerMacros();
    }

    public Project getProject() {
        return this.myProject;
    }

    public String getDisplayName(boolean shorten) {
        return shorten ? this.myNativeLibrary.getToolchainName() : String.format("Toolchain: '%1$s''", this.myNativeLibrary.getToolchainName());
    }

    public VirtualFile getPrecompiledHeader() {
        return null;
    }

    public HeaderRoots getProjectHeadersRoots() {
        return new HeaderRoots(Collections.emptyList());
    }

    public HeaderRoots getLibraryHeadersRoots(OCResolveRootAndConfiguration headerContext) {
        OCLanguageKind languageKind = headerContext.getKind();
        VirtualFile sourceFile = headerContext.getRootFile();
        if (languageKind == null) {
            languageKind = this.getLanguageKind(sourceFile);
        }
        ArrayList roots = Lists.newArrayList();
        if (languageKind == OCLanguageKind.C) {
            this.addHeaderRoots(roots, this.myNativeLibrary.getCIncludeDirs());
            this.addHeaderRoots(roots, this.myNativeLibrary.getCSystemIncludeDirs());
        } else {
            this.addHeaderRoots(roots, this.myNativeLibrary.getCppIncludeDirs());
            this.addHeaderRoots(roots, this.myNativeLibrary.getCppSystemIncludeDirs());
        }
        NdkCompilerInfoCache.NdkCompilerInfo compilerInfo = this.getNdkCompilerInfo(languageKind, sourceFile);
        if (compilerInfo != null) {
            roots.addAll(compilerInfo.getHeaderSearchPaths());
        }
        return new HeaderRoots((List)roots);
    }

    private void addHeaderRoots(List<PsiFileSystemItem> roots, List<File> includeDirs) {
        for (File includeDir : includeDirs) {
            VirtualFile virtualFile = this.findVirtualFile(includeDir);
            if (virtualFile == null) continue;
            roots.add((PsiFileSystemItem)new IncludedHeadersRoot(this.getProject(), virtualFile, false, false));
        }
    }

    private NdkCompilerInfoCache.NdkCompilerInfo getNdkCompilerInfo(OCLanguageKind languageKind, VirtualFile sourceFile) {
        try {
            return this.myCompilerInfoCache.getCompilerInfo(this.myProject, this.myCompilerSettings, languageKind, sourceFile);
        }
        catch (NdkCompilerInfoCache.NdkCompilerInvocationException e) {
            EVENT_LOG_NOTIFICATION.createNotification(e.getMessage(), MessageType.ERROR).notify(this.myProject);
            LOG.warn((Throwable)e);
            return null;
        }
    }

    protected VirtualFile findVirtualFile(File ioFile) {
        return VfsUtil.findFileByIoFile((File)ioFile, (boolean)true);
    }

    private OCLanguageKind getLanguageKind(VirtualFile sourceFile) {
        OCLanguageKind kind = OCLanguageKindCalculator.tryFileTypeAndExtension((Project)this.myProject, (VirtualFile)sourceFile);
        return kind != null ? kind : this.getMaximumLanguageKind();
    }

    public OCLanguageKind getDeclaredLanguageKind(VirtualFile sourceOrHeaderFile) {
        if (sourceOrHeaderFile == null) {
            return null;
        }
        String fileName = sourceOrHeaderFile.getName();
        if (OCFileTypeHelpers.isSourceFile((String)fileName)) {
            return this.getLanguageKind(sourceOrHeaderFile);
        }
        if (OCFileTypeHelpers.isHeaderFile((String)fileName)) {
            return this.getLanguageKind(this.getSourceFileForHeaderFile(sourceOrHeaderFile));
        }
        return null;
    }

    private VirtualFile getSourceFileForHeaderFile(VirtualFile headerFile) {
        ArrayList roots = new ArrayList(OCImportsGraph.getAllHeaderRoots((Project)this.myProject, (VirtualFile)headerFile));
        String headerNameWithoutExtension = headerFile.getNameWithoutExtension();
        for (VirtualFile root : roots) {
            if (!root.getNameWithoutExtension().equals(headerNameWithoutExtension)) continue;
            return root;
        }
        return null;
    }

    public OCLanguageKind getPrecompiledLanguageKind() {
        return this.getMaximumLanguageKind();
    }

    public OCLanguageKind getMaximumLanguageKind() {
        return OCLanguageKind.CPP;
    }

    public OCCompilerMacros getCompilerMacros() {
        return this.myCompilerMacros;
    }

    public OCCompilerSettings getCompilerSettings() {
        return this.myCompilerSettings;
    }

    public Object getIndexingCluster() {
        return null;
    }

    public int compareTo(OCResolveConfiguration o) {
        return OCWorkspaceUtil.compareConfigurations((OCResolveConfiguration)this, (OCResolveConfiguration)o);
    }

    public String getAbiString() {
        return this.myNativeLibrary.getAbi();
    }

    private class CompilerMacros
    extends OCCompilerMacros {
        private CompilerMacros() {
        }

        protected void fillFileMacros(OCInclusionContext context, PsiFile sourceFile) {
            NdkCompilerInfoCache.NdkCompilerInfo compilerInfo = ModuleResolveConfiguration.this.getNdkCompilerInfo(context.getLanguageKind(), OCInclusionContextUtil.getVirtualFile((PsiFile)sourceFile));
            if (compilerInfo == null) {
                return;
            }
            CompilerMacros.fillSubstitutions((OCInclusionContext)context, (String)compilerInfo.getDefines());
            this.enableClangFeatures(context, compilerInfo.getFeatures());
            this.enableClangExtensions(context, compilerInfo.getFeatures());
        }
    }

    private class CompilerSettings
    extends OCCompilerSettings {
        private final CidrToolEnvironment myToolEnvironment = new DefaultCidrToolEnvironment();
        private final File myWorkingDir;

        CompilerSettings(File workingDir) {
            this.myWorkingDir = workingDir;
        }

        public OCCompilerKind getCompiler(OCLanguageKind languageKind) {
            return null;
        }

        public File getCompilerExecutable(OCLanguageKind lang) {
            if (lang == OCLanguageKind.C) {
                return ModuleResolveConfiguration.this.myNativeToolchain.getCCompilerExecutable();
            }
            return ModuleResolveConfiguration.this.myNativeToolchain.getCppCompilerExecutable();
        }

        public File getCompilerWorkingDir() {
            return this.myWorkingDir;
        }

        public CidrToolEnvironment getEnvironment() {
            return this.myToolEnvironment;
        }

        public CidrCompilerSwitches getCompilerSwitches(OCLanguageKind lang, VirtualFile sourceFile) {
            List compilerFlags = lang == OCLanguageKind.C ? ModuleResolveConfiguration.this.myNativeLibrary.getCCompilerFlags() : ModuleResolveConfiguration.this.myNativeLibrary.getCppCompilerFlags();
            CidrSwitchBuilder builder = new CidrSwitchBuilder();
            for (String compilerFlag : compilerFlags) {
                if (compilerFlag.contains(" ")) {
                    if (compilerFlag.contains("\\ ")) {
                        compilerFlag = compilerFlag.replace("\\ ", " ");
                    }
                    compilerFlag = compilerFlag.replace(" ", "\\ ");
                }
                builder.addParameter(compilerFlag);
            }
            return builder.build();
        }
    }
}

