/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.serialization.JpsGlobalLoader;
import org.jetbrains.jps.model.serialization.JpsPathVariablesConfiguration;
import org.jetbrains.jps.model.serialization.JpsProjectSerializationDataExtension;
import org.jetbrains.jps.model.serialization.PathMacroUtil;
import org.jetbrains.jps.model.serialization.impl.JpsModuleSerializationDataExtensionImpl;
import org.jetbrains.jps.model.serialization.impl.JpsPathVariablesConfigurationImpl;
import org.jetbrains.jps.model.serialization.impl.JpsProjectSerializationDataExtensionImpl;
import org.jetbrains.jps.model.serialization.module.JpsModuleSerializationDataExtension;

public class JpsModelSerializationDataService {
    public static Map<String, String> getAllPathVariables(JpsGlobal global) {
        return JpsModelSerializationDataService.computeAllPathVariables(global);
    }

    public static Map<String, String> computeAllPathVariables(JpsGlobal global) {
        HashMap<String, String> pathVariables = new HashMap<String, String>(PathMacroUtil.getGlobalSystemMacros());
        JpsPathVariablesConfiguration configuration = JpsModelSerializationDataService.getPathVariablesConfiguration(global);
        if (configuration != null) {
            pathVariables.putAll(configuration.getAllUserVariables());
        }
        return pathVariables;
    }

    public static JpsPathVariablesConfiguration getPathVariablesConfiguration(JpsGlobal global) {
        return (JpsPathVariablesConfiguration)global.getContainer().getChild(JpsGlobalLoader.PATH_VARIABLES_ROLE);
    }

    public static JpsPathVariablesConfiguration getOrCreatePathVariablesConfiguration(JpsGlobal global) {
        JpsPathVariablesConfiguration child = (JpsPathVariablesConfiguration)global.getContainer().getChild(JpsGlobalLoader.PATH_VARIABLES_ROLE);
        if (child == null) {
            return (JpsPathVariablesConfiguration)global.getContainer().setChild(JpsGlobalLoader.PATH_VARIABLES_ROLE, (JpsElement)new JpsPathVariablesConfigurationImpl());
        }
        return child;
    }

    public static JpsProjectSerializationDataExtension getProjectExtension(JpsProject project) {
        return (JpsProjectSerializationDataExtension)project.getContainer().getChild(JpsProjectSerializationDataExtensionImpl.ROLE);
    }

    public static File getBaseDirectory(JpsProject project) {
        JpsProjectSerializationDataExtension extension = JpsModelSerializationDataService.getProjectExtension(project);
        return extension != null ? extension.getBaseDirectory() : null;
    }

    public static JpsModuleSerializationDataExtension getModuleExtension(JpsModule project) {
        return (JpsModuleSerializationDataExtension)project.getContainer().getChild(JpsModuleSerializationDataExtensionImpl.ROLE);
    }

    public static File getBaseDirectory(JpsModule module) {
        JpsModuleSerializationDataExtension extension = JpsModelSerializationDataService.getModuleExtension(module);
        return extension != null ? extension.getBaseDirectory() : null;
    }

    public static String getPathVariableValue(JpsGlobal global, String name) {
        String value = PathMacroUtil.getGlobalSystemMacroValue(name);
        if (value != null) {
            return value;
        }
        JpsPathVariablesConfiguration configuration = JpsModelSerializationDataService.getPathVariablesConfiguration(global);
        return configuration != null ? configuration.getUserVariableValue(name) : null;
    }
}

