/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization;

import com.intellij.openapi.util.JDOMUtil;
import org.jdom.Content;
import org.jdom.Element;

public class JDomSerializationUtil {
    protected static final String COMPONENT_ELEMENT = "component";
    protected static final String OPTION_ELEMENT = "option";
    protected static final String NAME_ATTRIBUTE = "name";
    protected static final String VALUE_ATTRIBUTE = "value";

    public static Element findComponent(Element root, String componentName) {
        for (Element element : JDOMUtil.getChildren((Element)root, (String)COMPONENT_ELEMENT)) {
            if (!componentName.equals(element.getAttributeValue(NAME_ATTRIBUTE))) continue;
            return element;
        }
        return null;
    }

    public static Element createComponentElement(String componentName) {
        Element element = new Element(COMPONENT_ELEMENT);
        element.setAttribute(NAME_ATTRIBUTE, componentName);
        return element;
    }

    public static Element findOrCreateComponentElement(Element root, String componentName) {
        Element component = JDomSerializationUtil.findComponent(root, componentName);
        if (component == null) {
            component = JDomSerializationUtil.createComponentElement(componentName);
            JDomSerializationUtil.addComponent(root, component);
        }
        return component;
    }

    public static void addComponent(Element root, Element component) {
        String componentName = component.getAttributeValue(NAME_ATTRIBUTE);
        Element old = JDomSerializationUtil.findComponent(root, componentName);
        if (old != null) {
            root.removeContent((Content)old);
        }
        for (int i = 0; i < root.getContent().size(); ++i) {
            String name;
            Element element;
            Object o = root.getContent().get(i);
            if (!(o instanceof Element) || !(element = (Element)o).getName().equals(COMPONENT_ELEMENT) || componentName.compareTo(name = element.getAttributeValue(NAME_ATTRIBUTE)) >= 0) continue;
            root.addContent(i, (Content)component);
            return;
        }
        root.addContent(component);
    }
}

