/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.module.impl;

import java.io.File;
import java.util.Set;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementType;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.module.JpsTypedModuleSourceRoot;
import org.jetbrains.jps.util.JpsPathUtil;

public class JpsModuleSourceRootImpl<P extends JpsElement>
extends JpsCompositeElementBase<JpsModuleSourceRootImpl<P>>
implements JpsTypedModuleSourceRoot<P> {
    private final JpsModuleSourceRootType<P> myRootType;
    private final String myUrl;

    public JpsModuleSourceRootImpl(String url, JpsModuleSourceRootType<P> type, P properties) {
        this.myRootType = type;
        this.myContainer.setChild(type.getPropertiesRole(), properties);
        this.myUrl = url;
    }

    private JpsModuleSourceRootImpl(JpsModuleSourceRootImpl<P> original) {
        super(original);
        this.myRootType = original.myRootType;
        this.myUrl = original.myUrl;
    }

    public <P extends JpsElement> P getProperties(JpsModuleSourceRootType<P> type) {
        if (this.myRootType.equals(type)) {
            return (P)this.myContainer.getChild(this.myRootType.getPropertiesRole());
        }
        return null;
    }

    public <P extends JpsElement> P getProperties(Set<? extends JpsModuleSourceRootType<P>> types) {
        if (types.contains(this.myRootType)) {
            return this.getProperties();
        }
        return null;
    }

    public <P extends JpsElement> JpsTypedModuleSourceRoot<P> asTyped(JpsModuleSourceRootType<P> type) {
        return this.myRootType.equals(type) ? this : null;
    }

    public JpsTypedModuleSourceRoot<?> asTyped() {
        return this;
    }

    public JpsElementType<?> getType() {
        return this.myRootType;
    }

    public P getProperties() {
        return (P)this.myContainer.getChild(this.myRootType.getPropertiesRole());
    }

    public JpsModuleSourceRootType<P> getRootType() {
        return this.myRootType;
    }

    public String getUrl() {
        return this.myUrl;
    }

    public File getFile() {
        return JpsPathUtil.urlToFile((String)this.myUrl);
    }

    public JpsModuleSourceRootImpl<P> createCopy() {
        return new JpsModuleSourceRootImpl<P>(this);
    }
}

