/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.schema;

import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.schema.AnyType;
import com.android.tools.rpclib.schema.Array;
import com.android.tools.rpclib.schema.Interface;
import com.android.tools.rpclib.schema.Map;
import com.android.tools.rpclib.schema.Method;
import com.android.tools.rpclib.schema.Pointer;
import com.android.tools.rpclib.schema.Primitive;
import com.android.tools.rpclib.schema.Slice;
import com.android.tools.rpclib.schema.Struct;
import com.android.tools.rpclib.schema.TypeTag;
import com.android.tools.rpclib.schema.Variant;
import java.io.IOException;

public abstract class Type {
    private String mName = null;

    public final String getName() {
        if (this.mName == null) {
            StringBuilder out = new StringBuilder();
            this.name(out);
            this.mName = out.toString();
        }
        return this.mName;
    }

    public abstract void encodeValue(Encoder var1, Object var2) throws IOException;

    public abstract Object decodeValue(Decoder var1) throws IOException;

    public abstract void encode(Encoder var1) throws IOException;

    public static Type decode(Decoder d) throws IOException {
        byte v = d.uint8();
        TypeTag tag = new TypeTag((byte)(v & 0xF));
        v = (byte)(v >> 4 & 0xF);
        switch (tag.value) {
            case 0: {
                return new Primitive(d, new Method(v));
            }
            case 1: {
                return new Struct(d);
            }
            case 2: {
                return new Pointer(d);
            }
            case 3: {
                return new Interface(d);
            }
            case 4: {
                return new Variant(d);
            }
            case 5: {
                return new AnyType(d);
            }
            case 6: {
                return new Slice(d);
            }
            case 7: {
                return new Array(d);
            }
            case 8: {
                return new Map(d);
            }
        }
        throw new IOException("Decode unknown type " + tag);
    }

    abstract void name(StringBuilder var1);

    public abstract void signature(StringBuilder var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Type)) {
            return false;
        }
        return this.getName().equals(((Type)o).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

