/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.schema;

import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.schema.Type;
import com.android.tools.rpclib.schema.TypeTag;
import java.io.IOException;

public final class Slice
extends Type {
    String mAlias;
    Type mValueType;

    public Slice(Decoder d) throws IOException {
        this.mValueType = Type.decode(d);
        this.mAlias = d.nonCompactString();
    }

    public Slice(String alias, Type valueType) {
        this.mAlias = alias;
        this.mValueType = valueType;
    }

    public String getAlias() {
        return this.mAlias;
    }

    public Type getValueType() {
        return this.mValueType;
    }

    @Override
    public void encodeValue(Encoder e, Object value) throws IOException {
        assert (value instanceof Object[]);
        Object[] array = (Object[])value;
        e.uint32(array.length);
        for (Object v : array) {
            this.mValueType.encodeValue(e, v);
        }
    }

    @Override
    public Object decodeValue(Decoder d) throws IOException {
        Object[] array = new Object[d.uint32()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.mValueType.decodeValue(d);
        }
        return array;
    }

    @Override
    public void encode(Encoder e) throws IOException {
        TypeTag.sliceTag().encode(e);
        this.mValueType.encode(e);
        e.nonCompactString(this.mAlias);
    }

    @Override
    void name(StringBuilder out) {
        out.append("slice<");
        this.mValueType.name(out);
        out.append('>');
    }

    @Override
    public void signature(StringBuilder out) {
        out.append("[]");
        this.mValueType.signature(out);
    }
}

