/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.schema;

import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.schema.Type;
import com.android.tools.rpclib.schema.TypeTag;
import com.intellij.util.containers.HashMap;
import java.io.IOException;
import java.util.Map;

public final class Map
extends Type {
    String mAlias;
    Type mKeyType;
    Type mValueType;

    public Map(Decoder d) throws IOException {
        this.mKeyType = Map.decode(d);
        this.mValueType = Map.decode(d);
        this.mAlias = d.nonCompactString();
    }

    public String getAlias() {
        return this.mAlias;
    }

    public Type getKeyType() {
        return this.mKeyType;
    }

    @Override
    public void encodeValue(Encoder e, Object value) throws IOException {
        assert (value instanceof java.util.Map);
        java.util.Map map = (java.util.Map)value;
        e.uint32(map.size());
        for (Map.Entry entry : map.entrySet()) {
            this.mKeyType.encodeValue(e, entry.getKey());
            this.mValueType.encodeValue(e, entry.getValue());
        }
    }

    @Override
    public Object decodeValue(Decoder d) throws IOException {
        int size = d.uint32();
        HashMap map = new HashMap();
        for (int i = 0; i < size; ++i) {
            map.put(this.mKeyType.decodeValue(d), this.mValueType.decodeValue(d));
        }
        return map;
    }

    public Type getValueType() {
        return this.mValueType;
    }

    @Override
    public void encode(Encoder e) throws IOException {
        TypeTag.mapTag().encode(e);
        this.mKeyType.encode(e);
        this.mValueType.encode(e);
        e.nonCompactString(this.mAlias);
    }

    @Override
    void name(StringBuilder out) {
        out.append("map<");
        this.mKeyType.name(out);
        out.append(',');
        this.mValueType.name(out);
        out.append('>');
    }

    @Override
    public void signature(StringBuilder out) {
        out.append("map[");
        this.mKeyType.signature(out);
        out.append(']');
        this.mValueType.signature(out);
    }
}

