/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.schema;

import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.schema.Field;
import com.android.tools.rpclib.schema.Type;
import java.io.IOException;

public final class Entity {
    private String mPackage;
    private String mIdentity;
    private String mVersion;
    private String mDisplay;
    private Field[] mFields;
    private BinaryObject[] mMetadata;
    private String mSignature;

    public Entity(String pkg, String identity, String version, String display) {
        this.mPackage = pkg;
        this.mIdentity = identity;
        this.mVersion = version;
        this.mDisplay = display;
        this.mFields = new Field[0];
    }

    public Entity() {
    }

    public void decode(Decoder d) throws IOException {
        int i;
        this.mPackage = d.string();
        this.mIdentity = d.string();
        this.mVersion = d.string();
        this.mDisplay = d.nonCompactString();
        this.mFields = new Field[d.uint32()];
        for (i = 0; i < this.mFields.length; ++i) {
            this.mFields[i] = new Field();
            this.mFields[i].mType = Type.decode(d);
            this.mFields[i].mDeclared = d.nonCompactString();
        }
        if (d.getMode() != 0) {
            this.mMetadata = new BinaryObject[d.uint32()];
            for (i = 0; i < this.mMetadata.length; ++i) {
                this.mMetadata[i] = d.object();
            }
        }
    }

    public String getPackage() {
        return this.mPackage;
    }

    public String getName() {
        return this.mDisplay == "" ? this.mIdentity : this.mDisplay;
    }

    public Field[] getFields() {
        return this.mFields;
    }

    public void setFields(Field[] fields) {
        this.mFields = fields;
    }

    public BinaryObject[] getMetadata() {
        return this.mMetadata;
    }

    public void encode(Encoder e) throws IOException {
        e.string(this.mPackage);
        e.string(this.mIdentity);
        e.string(this.mVersion);
        e.nonCompactString(this.mDisplay);
        e.uint32(this.mFields.length);
        for (Field field : this.mFields) {
            field.mType.encode(e);
            e.nonCompactString(field.mDeclared);
        }
        if (e.getMode() != 0) {
            e.uint32(this.mMetadata.length);
            for (BinaryObject meta : this.mMetadata) {
                e.object(meta);
            }
        }
    }

    public String signature() {
        if (this.mSignature == null) {
            StringBuilder out = new StringBuilder();
            out.append(this.mPackage).append('.').append(this.mIdentity);
            if (this.mVersion.length() > 0) {
                out.append('@').append(this.mVersion);
            }
            out.append('{');
            for (int index = 0; index < this.mFields.length; ++index) {
                if (index > 0) {
                    out.append(',');
                }
                this.mFields[index].getType().signature(out);
            }
            out.append('}');
            this.mSignature = out.toString();
        }
        return this.mSignature;
    }
}

