/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.rpclib.schema;

import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.schema.Constant;
import com.android.tools.rpclib.schema.Type;
import com.intellij.util.containers.HashMap;
import java.io.IOException;

public final class ConstantSet {
    private Type mType;
    private Constant[] mEntries;
    private static final HashMap<Type, ConstantSet> mRegistry = new HashMap();

    public static void register(ConstantSet set) {
        mRegistry.put((Object)set.getType(), (Object)set);
    }

    public static ConstantSet lookup(Type type) {
        return (ConstantSet)mRegistry.get((Object)type);
    }

    public ConstantSet(Decoder d) throws IOException {
        this.mType = Type.decode(d);
        this.mEntries = new Constant[d.uint32()];
        for (int i = 0; i < this.mEntries.length; ++i) {
            this.mEntries[i] = new Constant();
            this.mEntries[i].mName = d.string();
            this.mEntries[i].mValue = this.mType.decodeValue(d);
        }
    }

    public Type getType() {
        return this.mType;
    }

    public Constant[] getEntries() {
        return this.mEntries;
    }

    public void encode(Encoder e) throws IOException {
        this.mType.encode(e);
        for (Constant mEntry : this.mEntries) {
            e.string(mEntry.mName);
            this.mType.encodeValue(e, mEntry.mValue);
        }
    }
}

