/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import org.netbeans.lib.cvsclient.IConnectionStreams;
import org.netbeans.lib.cvsclient.SmartCvsSrcBundle;
import org.netbeans.lib.cvsclient.file.AbstractFileObject;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;
import org.netbeans.lib.cvsclient.file.ILocalFileReader;
import org.netbeans.lib.cvsclient.file.ISendTextFilePreprocessor;
import org.netbeans.lib.cvsclient.util.BugLog;

public final class LocalFileReader
implements ILocalFileReader {
    private static final int CHUNK_SIZE = 32768;
    private final ISendTextFilePreprocessor sendTextFilePreprocessor;
    private static final String CVS_DIR = "CVS";

    public LocalFileReader(ISendTextFilePreprocessor sendTextFilePreprocessor) {
        BugLog.getInstance().assertNotNull((Object)sendTextFilePreprocessor);
        this.sendTextFilePreprocessor = sendTextFilePreprocessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transmitTextFile(FileObject fileObject, IConnectionStreams connectionStreams, ICvsFileSystem cvsFileSystem) throws IOException {
        long length;
        File file = cvsFileSystem.getLocalFileSystem().getFile((AbstractFileObject)fileObject);
        if (!file.exists()) {
            throw new FileNotFoundException(SmartCvsSrcBundle.message("file.does.not.exist.error.message", file.getAbsolutePath()));
        }
        File fileToSend = this.sendTextFilePreprocessor.getPreprocessedTextFile(file, connectionStreams.getWriterFactory());
        this.writeLengthString(connectionStreams.getLoggedWriter(), length);
        BufferedInputStream bis = null;
        try {
            int count;
            bis = new BufferedInputStream(new FileInputStream(fileToSend));
            OutputStream outputStream = connectionStreams.getOutputStream();
            byte[] chunk = new byte[32768];
            for (length = fileToSend.length(); length > 0L; length -= (long)count) {
                int bytesToRead = length >= 32768L ? 32768 : (int)length;
                count = bis.read(chunk, 0, bytesToRead);
                outputStream.write(chunk, 0, count);
            }
            outputStream.flush();
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ex) {}
            }
            this.sendTextFilePreprocessor.cleanup(fileToSend);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transmitBinaryFile(FileObject fileObject, IConnectionStreams connectionStreams, ICvsFileSystem cvsFileSystem) throws IOException {
        long length;
        File file = cvsFileSystem.getLocalFileSystem().getFile((AbstractFileObject)fileObject);
        this.writeLengthString(connectionStreams.getLoggedWriter(), length);
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        try {
            int count;
            OutputStream outputStream = connectionStreams.getOutputStream();
            byte[] chunk = new byte[32768];
            for (length = file.length(); length > 0L; length -= (long)count) {
                int bytesToRead = length >= 32768L ? 32768 : (int)length;
                count = bis.read(chunk, 0, bytesToRead);
                outputStream.write(chunk, 0, count);
            }
            outputStream.flush();
        }
        finally {
            try {
                bis.close();
            }
            catch (IOException ex) {}
        }
    }

    public boolean exists(AbstractFileObject fileObject, ICvsFileSystem cvsFileSystem) {
        return cvsFileSystem.getLocalFileSystem().getFile(fileObject).exists();
    }

    public boolean isWritable(FileObject fileObject, ICvsFileSystem cvsFileSystem) {
        return cvsFileSystem.getLocalFileSystem().getFile((AbstractFileObject)fileObject).canWrite();
    }

    public void listFilesAndDirectories(DirectoryObject directoryObject, Collection fileNames, Collection directoryNames, ICvsFileSystem cvsFileSystem) {
        File directory = cvsFileSystem.getLocalFileSystem().getFile((AbstractFileObject)directoryObject);
        File[] filesAndDirectories = directory.listFiles();
        if (filesAndDirectories == null) {
            return;
        }
        for (int i = 0; i < filesAndDirectories.length; ++i) {
            File fileOrDirectory = filesAndDirectories[i];
            String name = fileOrDirectory.getName();
            if (name.equals(CVS_DIR)) continue;
            if (fileOrDirectory.isDirectory()) {
                if (directoryNames == null) continue;
                directoryNames.add(name);
                continue;
            }
            if (fileNames == null) continue;
            fileNames.add(name);
        }
    }

    private void writeLengthString(Writer writer, long length) throws IOException {
        writer.write(String.valueOf(length));
        writer.write(10);
        writer.flush();
    }
}

