/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.jps.builder;

import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

class BuilderExecutionSettings {
    private final File myGradleHomeDir;
    private final File myGradleServiceDir;
    private final File myJavaHomeDir;
    private final File myProjectDir;
    private final BuildMode myBuildMode;
    private final List<String> myGradleTasksToInvoke;
    private final List<String> myCommandLineOptions;
    private final List<String> myJvmOptions;
    private final boolean myEmbeddedModeEnabled = SystemProperties.getBooleanProperty((String)"com.android.studio.gradle.use.embedded.daemon", (boolean)false);
    private final boolean myVerboseLoggingEnabled;
    private final boolean myParallelBuild;
    private final boolean myOfflineBuildMode;
    private final boolean myConfigureOnDemand;

    BuilderExecutionSettings() {
        this.myGradleHomeDir = BuilderExecutionSettings.findDir("com.android.studio.gradle.home.path", "Gradle home");
        this.myGradleServiceDir = BuilderExecutionSettings.findDir("com.android.studio.gradle.service.dir.path", "Gradle service");
        this.myJavaHomeDir = BuilderExecutionSettings.findDir("com.android.studio.gradle.java.home.path", "Java home");
        this.myProjectDir = BuilderExecutionSettings.findProjectRootDir();
        String buildActionName = System.getProperty("com.android.studio.gradle.build.mode");
        this.myBuildMode = Strings.isNullOrEmpty((String)buildActionName) ? BuildMode.DEFAULT_BUILD_MODE : BuildMode.valueOf((String)buildActionName);
        this.myGradleTasksToInvoke = BuilderExecutionSettings.getJvmArgGroup("com.android.studio.gradle.gradle.tasks.");
        this.myCommandLineOptions = BuilderExecutionSettings.getJvmArgGroup("com.android.studio.gradle.daemon.command.line.option.");
        this.myJvmOptions = BuilderExecutionSettings.getJvmArgGroup("com.android.studio.gradle.daemon.jvm.option.");
        this.myVerboseLoggingEnabled = SystemProperties.getBooleanProperty((String)"com.android.studio.gradle.use.verbose.logging", (boolean)false);
        this.myParallelBuild = SystemProperties.getBooleanProperty((String)"compile.parallel", (boolean)false);
        this.myOfflineBuildMode = SystemProperties.getBooleanProperty((String)"com.android.studio.gradle.offline.mode", (boolean)false);
        this.myConfigureOnDemand = SystemProperties.getBooleanProperty((String)"com.android.studio.gradle.configuration.on.demand", (boolean)false);
        this.populateHttpProxyJvmOptions();
    }

    private static File findDir(String jvmArgName, String dirType) {
        File gradleServiceDir = BuilderExecutionSettings.createFile(jvmArgName);
        if (gradleServiceDir == null) {
            return null;
        }
        BuilderExecutionSettings.ensureDirectoryExists(gradleServiceDir, dirType);
        return gradleServiceDir;
    }

    private static File findProjectRootDir() {
        File projectRootDir = BuilderExecutionSettings.createFile("com.android.studio.gradle.project.path");
        if (projectRootDir == null) {
            throw new NullPointerException("Project directory not specified");
        }
        BuilderExecutionSettings.ensureDirectoryExists(projectRootDir, "project");
        return projectRootDir;
    }

    private static void ensureDirectoryExists(File dir, String type) {
        if (!dir.isDirectory()) {
            String path = dir.getPath();
            String msg = String.format("Unable to obtain %1$s directory: the file '%2$s' is not a directory", type, path);
            throw new IllegalArgumentException(msg);
        }
    }

    private static File createFile(String jvmArgName) {
        String path = System.getProperty(jvmArgName);
        return path != null && !path.isEmpty() ? new File(path) : null;
    }

    private static List<String> getJvmArgGroup(String argPrefix) {
        String arg;
        ArrayList args = Lists.newArrayList();
        int counter = 0;
        while (!Strings.isNullOrEmpty((String)(arg = System.getProperty(argPrefix + counter++)))) {
            args.add(arg);
        }
        return args;
    }

    private void populateHttpProxyJvmOptions() {
        String jvmOption;
        int counter = 0;
        while (!Strings.isNullOrEmpty((String)(jvmOption = System.getProperty("com.android.studio.gradle.proxy.property." + counter++)))) {
            int indexOfSeparator = jvmOption.indexOf(":");
            if (indexOfSeparator < 0 || indexOfSeparator >= jvmOption.length() - 1) continue;
            String arg = AndroidGradleSettings.createJvmArg((String)jvmOption.substring(0, indexOfSeparator), (String)jvmOption.substring(indexOfSeparator + 1));
            this.myJvmOptions.add(arg);
        }
    }

    boolean isEmbeddedModeEnabled() {
        return this.myEmbeddedModeEnabled;
    }

    boolean isVerboseLoggingEnabled() {
        return this.myVerboseLoggingEnabled;
    }

    List<String> getCommandLineOptions() {
        return this.myCommandLineOptions;
    }

    List<String> getJvmOptions() {
        return this.myJvmOptions;
    }

    File getGradleHomeDir() {
        return this.myGradleHomeDir;
    }

    File getGradleServiceDir() {
        return this.myGradleServiceDir;
    }

    File getJavaHomeDir() {
        return this.myJavaHomeDir;
    }

    File getProjectDir() {
        return this.myProjectDir;
    }

    BuildMode getBuildMode() {
        return this.myBuildMode;
    }

    boolean isParallelBuild() {
        return this.myParallelBuild;
    }

    boolean isOfflineBuild() {
        return this.myOfflineBuildMode;
    }

    public boolean isConfigureOnDemand() {
        return this.myConfigureOnDemand;
    }

    List<String> getGradleTasksToInvoke() {
        return this.myGradleTasksToInvoke;
    }

    public String toString() {
        return "BuilderExecutionSettings[buildMode=" + this.myBuildMode.name() + ", commandLineOptions=" + this.myCommandLineOptions + ", embeddedModeEnabled=" + this.myEmbeddedModeEnabled + ", gradleHomeDir=" + this.myGradleHomeDir + ", gradleServiceDir=" + this.myGradleServiceDir + ", javaHomeDir=" + this.myJavaHomeDir + ", jvmOptions=" + this.myJvmOptions + ", gradleTasksToInvoke=" + this.myGradleTasksToInvoke + ", offlineBuild=" + this.myOfflineBuildMode + ", parallelBuild=" + this.myParallelBuild + ", projectDir=" + this.myProjectDir + ", verboseLoggingEnabled=" + this.myVerboseLoggingEnabled + ']';
    }
}

