/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.jps.builder;

import com.android.tools.idea.jps.AndroidGradleJps;
import com.android.tools.idea.jps.model.JpsAndroidGradleModuleExtension;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.UserDataHolder;
import java.util.List;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.android.AndroidSourceGeneratingBuilder;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.incremental.resources.ResourcesBuilder;
import org.jetbrains.jps.incremental.resources.StandardResourceBuilderEnabler;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidGradleBuilder
extends ModuleLevelBuilder {
    private static final String BUILDER_NAME = "Android Gradle Builder";

    protected AndroidGradleBuilder() {
        super(BuilderCategory.TRANSLATOR);
        ResourcesBuilder.registerEnabler((StandardResourceBuilderEnabler)new StandardResourceBuilderEnabler(){

            public boolean isResourceProcessingEnabled(JpsModule module) {
                JpsProject project = module.getProject();
                return !AndroidGradleJps.hasAndroidGradleFacet(project);
            }
        });
    }

    public void buildStarted(CompileContext context) {
        JpsProject project = context.getProjectDescriptor().getProject();
        if (AndroidGradleJps.hasAndroidGradleFacet(project)) {
            JavaBuilder.IS_ENABLED.set((UserDataHolder)context, (Object)false);
            AndroidSourceGeneratingBuilder.IS_ENABLED.set((UserDataHolder)context, (Object)false);
        }
    }

    public ModuleLevelBuilder.ExitCode build(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleLevelBuilder.OutputConsumer outputConsumer) {
        JpsAndroidGradleModuleExtension extension = AndroidGradleJps.getFirstExtension(chunk);
        if (extension == null) {
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        return ModuleLevelBuilder.ExitCode.OK;
    }

    public String getPresentableName() {
        return BUILDER_NAME;
    }

    public List<String> getCompilableFileExtensions() {
        return ImmutableList.of((Object)"aidl", (Object)"fs", (Object)"java", (Object)"rs");
    }
}

