/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts.internal;

import org.codehaus.groovy.control.CompilationUnit;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.Transformer;
import org.gradle.groovy.scripts.internal.FixMainScriptTransformer;
import org.gradle.groovy.scripts.internal.ScriptSourceDescriptionTransformer;
import org.gradle.groovy.scripts.internal.StatementLabelsScriptTransformer;
import org.gradle.groovy.scripts.internal.TaskDefinitionScriptTransformer;
import org.gradle.model.dsl.internal.transform.ModelBlockTransformer;

public class BuildScriptTransformer
implements Transformer {
    private final String id;
    private final Transformer extractionTransformer;
    private final ScriptSource scriptSource;

    public BuildScriptTransformer(String id, Transformer extractionTransformer, ScriptSource scriptSource) {
        this.id = id;
        this.extractionTransformer = extractionTransformer;
        this.scriptSource = scriptSource;
    }

    public String getId() {
        return this.id;
    }

    public void register(CompilationUnit compilationUnit) {
        this.extractionTransformer.register(compilationUnit);
        new TaskDefinitionScriptTransformer().register(compilationUnit);
        new FixMainScriptTransformer().register(compilationUnit);
        new StatementLabelsScriptTransformer().register(compilationUnit);
        new ScriptSourceDescriptionTransformer(this.scriptSource.getDisplayName()).register(compilationUnit);
        new ModelBlockTransformer().register(compilationUnit);
    }
}

