/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import com.google.common.collect.ImmutableList;
import groovy.lang.Closure;
import java.io.File;
import java.io.FilterReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.NonExtensible;
import org.gradle.api.file.CopyProcessingSpec;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.ChainingTransformer;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.file.copy.CopySpecResolver;
import org.gradle.api.internal.file.copy.CopySpecSource;
import org.gradle.api.internal.file.copy.CopySpecWrapper;
import org.gradle.api.internal.file.copy.MatchingCopyAction;
import org.gradle.api.internal.file.copy.PathNotationParser;
import org.gradle.api.internal.file.copy.RegExpNameMapper;
import org.gradle.api.internal.file.copy.RenamingCopyAction;
import org.gradle.api.internal.file.copy.SingleParentCopySpec;
import org.gradle.api.internal.file.pattern.PatternMatcherFactory;
import org.gradle.api.specs.NotSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.util.ConfigureUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonExtensible
public class DefaultCopySpec
implements CopySpecInternal {
    private static final NotationParser<Object, String> PATH_NOTATION_PARSER = PathNotationParser.create();
    protected final FileResolver fileResolver;
    private final Set<Object> sourcePaths;
    private Object destDir;
    private final PatternSet patternSet;
    protected final List<CopySpecInternal> childSpecs;
    protected final Instantiator instantiator;
    private final List<Action<? super FileCopyDetails>> copyActions = new ArrayList<Action<? super FileCopyDetails>>();
    private Integer dirMode;
    private Integer fileMode;
    private Boolean caseSensitive;
    private Boolean includeEmptyDirs;
    private DuplicatesStrategy duplicatesStrategy;

    public DefaultCopySpec(FileResolver resolver, Instantiator instantiator) {
        this.fileResolver = resolver;
        this.instantiator = instantiator;
        this.sourcePaths = new LinkedHashSet<Object>();
        this.childSpecs = new ArrayList<CopySpecInternal>();
        this.patternSet = new PatternSet();
        this.duplicatesStrategy = null;
    }

    protected List<Action<? super FileCopyDetails>> getCopyActions() {
        return this.copyActions;
    }

    @Override
    public CopySpec with(CopySpec ... copySpecs) {
        for (CopySpec copySpec : copySpecs) {
            CopySpecInternal copySpecInternal;
            if (copySpec instanceof CopySpecSource) {
                CopySpecSource copySpecSource = (CopySpecSource)((Object)copySpec);
                copySpecInternal = copySpecSource.getRootSpec();
            } else {
                copySpecInternal = (CopySpecInternal)copySpec;
            }
            this.childSpecs.add(copySpecInternal);
        }
        return this;
    }

    @Override
    public CopySpec from(Object ... sourcePaths) {
        for (Object sourcePath : sourcePaths) {
            this.sourcePaths.add(sourcePath);
        }
        return this;
    }

    @Override
    public CopySpec from(Object sourcePath, Closure c) {
        if (c == null) {
            this.from(sourcePath);
            return this;
        }
        CopySpecInternal child = this.addChild();
        child.from(sourcePath);
        return (CopySpec)ConfigureUtil.configure(c, this.instantiator.newInstance(CopySpecWrapper.class, new Object[]{child}));
    }

    @Override
    public CopySpecInternal addFirst() {
        return this.addChildAtPosition(0);
    }

    protected CopySpecInternal addChildAtPosition(int position) {
        DefaultCopySpec child = (DefaultCopySpec)this.instantiator.newInstance(SingleParentCopySpec.class, new Object[]{this.fileResolver, this.instantiator, this.buildRootResolver()});
        this.childSpecs.add(position, child);
        return child;
    }

    @Override
    public CopySpecInternal addChild() {
        SingleParentCopySpec child = new SingleParentCopySpec(this.fileResolver, this.instantiator, this.buildRootResolver());
        this.childSpecs.add(child);
        return child;
    }

    @Override
    public CopySpecInternal addChildBeforeSpec(CopySpecInternal childSpec) {
        int position = this.childSpecs.indexOf(childSpec);
        return position != -1 ? this.addChildAtPosition(position) : this.addChild();
    }

    public Set<Object> getSourcePaths() {
        return this.sourcePaths;
    }

    @Override
    public DefaultCopySpec into(Object destDir) {
        this.destDir = destDir;
        return this;
    }

    @Override
    public CopySpec into(Object destPath, Closure configureClosure) {
        if (configureClosure == null) {
            this.into(destPath);
            return this;
        }
        CopySpecInternal child = this.addChild();
        child.into(destPath);
        return (CopySpec)ConfigureUtil.configure(configureClosure, this.instantiator.newInstance(CopySpecWrapper.class, new Object[]{child}));
    }

    @Override
    public boolean isCaseSensitive() {
        return this.buildRootResolver().isCaseSensitive();
    }

    @Override
    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    @Override
    public boolean getIncludeEmptyDirs() {
        return this.buildRootResolver().getIncludeEmptyDirs();
    }

    @Override
    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
        this.includeEmptyDirs = includeEmptyDirs;
    }

    @Override
    public DuplicatesStrategy getDuplicatesStrategy() {
        return this.buildRootResolver().getDuplicatesStrategy();
    }

    @Override
    public void setDuplicatesStrategy(DuplicatesStrategy strategy) {
        this.duplicatesStrategy = strategy;
    }

    @Override
    public CopySpec filesMatching(String pattern, Action<? super FileCopyDetails> action) {
        Spec<RelativePath> matcher = PatternMatcherFactory.getPatternMatcher(true, this.isCaseSensitive(), pattern);
        return this.eachFile(new MatchingCopyAction(matcher, action));
    }

    @Override
    public CopySpec filesNotMatching(String pattern, Action<? super FileCopyDetails> action) {
        Spec<RelativePath> matcher = PatternMatcherFactory.getPatternMatcher(true, this.isCaseSensitive(), pattern);
        return this.eachFile(new MatchingCopyAction((Spec<RelativePath>)new NotSpec(matcher), action));
    }

    @Override
    public CopySpec include(String ... includes) {
        this.patternSet.include(includes);
        return this;
    }

    @Override
    public CopySpec include(Iterable<String> includes) {
        this.patternSet.include((Iterable)includes);
        return this;
    }

    @Override
    public CopySpec include(Spec<FileTreeElement> includeSpec) {
        this.patternSet.include((Spec)includeSpec);
        return this;
    }

    @Override
    public CopySpec include(Closure includeSpec) {
        this.patternSet.include(includeSpec);
        return this;
    }

    @Override
    public Set<String> getIncludes() {
        return this.patternSet.getIncludes();
    }

    @Override
    public CopySpec setIncludes(Iterable<String> includes) {
        this.patternSet.setIncludes((Iterable)includes);
        return this;
    }

    @Override
    public CopySpec exclude(String ... excludes) {
        this.patternSet.exclude(excludes);
        return this;
    }

    @Override
    public CopySpec exclude(Iterable<String> excludes) {
        this.patternSet.exclude((Iterable)excludes);
        return this;
    }

    @Override
    public CopySpec exclude(Spec<FileTreeElement> excludeSpec) {
        this.patternSet.exclude((Spec)excludeSpec);
        return this;
    }

    @Override
    public CopySpec exclude(Closure excludeSpec) {
        this.patternSet.exclude(excludeSpec);
        return this;
    }

    @Override
    public Set<String> getExcludes() {
        return this.patternSet.getExcludes();
    }

    @Override
    public DefaultCopySpec setExcludes(Iterable<String> excludes) {
        this.patternSet.setExcludes((Iterable)excludes);
        return this;
    }

    @Override
    public CopySpec rename(String sourceRegEx, String replaceWith) {
        this.copyActions.add(new RenamingCopyAction(new RegExpNameMapper(sourceRegEx, replaceWith)));
        return this;
    }

    @Override
    public CopySpec rename(Pattern sourceRegEx, String replaceWith) {
        this.copyActions.add(new RenamingCopyAction(new RegExpNameMapper(sourceRegEx, replaceWith)));
        return this;
    }

    @Override
    public CopySpec filter(final Class<? extends FilterReader> filterType) {
        this.copyActions.add((Action<? super FileCopyDetails>)new Action<FileCopyDetails>(){

            public void execute(FileCopyDetails fileCopyDetails) {
                fileCopyDetails.filter(filterType);
            }
        });
        return this;
    }

    @Override
    public CopySpec filter(final Closure closure) {
        this.copyActions.add((Action<? super FileCopyDetails>)new Action<FileCopyDetails>(){

            public void execute(FileCopyDetails fileCopyDetails) {
                fileCopyDetails.filter(closure);
            }
        });
        return this;
    }

    @Override
    public CopySpec filter(final Map<String, ?> properties, final Class<? extends FilterReader> filterType) {
        this.copyActions.add((Action<? super FileCopyDetails>)new Action<FileCopyDetails>(){

            public void execute(FileCopyDetails fileCopyDetails) {
                fileCopyDetails.filter(properties, filterType);
            }
        });
        return this;
    }

    @Override
    public CopySpec expand(final Map<String, ?> properties) {
        this.copyActions.add((Action<? super FileCopyDetails>)new Action<FileCopyDetails>(){

            public void execute(FileCopyDetails fileCopyDetails) {
                fileCopyDetails.expand(properties);
            }
        });
        return this;
    }

    @Override
    public CopySpec rename(Closure closure) {
        ChainingTransformer<String> transformer = new ChainingTransformer<String>(String.class);
        transformer.add(closure);
        this.copyActions.add(new RenamingCopyAction(transformer));
        return this;
    }

    @Override
    public Integer getDirMode() {
        return this.buildRootResolver().getDirMode();
    }

    @Override
    public Integer getFileMode() {
        return this.buildRootResolver().getFileMode();
    }

    @Override
    public CopyProcessingSpec setDirMode(Integer mode) {
        this.dirMode = mode;
        return this;
    }

    @Override
    public CopyProcessingSpec setFileMode(Integer mode) {
        this.fileMode = mode;
        return this;
    }

    @Override
    public CopySpec eachFile(Action<? super FileCopyDetails> action) {
        this.copyActions.add(action);
        return this;
    }

    @Override
    public CopySpec eachFile(Closure closure) {
        this.copyActions.add((Action<? super FileCopyDetails>)new ClosureBackedAction(closure));
        return this;
    }

    @Override
    public Iterable<CopySpecInternal> getChildren() {
        return this.childSpecs;
    }

    @Override
    public void walk(Action<? super CopySpecResolver> action) {
        this.buildRootResolver().walk(action);
    }

    @Override
    public boolean hasSource() {
        if (!this.sourcePaths.isEmpty()) {
            return true;
        }
        for (CopySpecInternal spec : this.childSpecs) {
            if (!spec.hasSource()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CopySpecResolver buildResolverRelativeToParent(CopySpecResolver parent) {
        return new DefaultCopySpecResolver(parent);
    }

    @Override
    public CopySpecResolver buildRootResolver() {
        return new DefaultCopySpecResolver(null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DefaultCopySpecResolver
    implements CopySpecResolver {
        private CopySpecResolver parentResolver;

        private DefaultCopySpecResolver(CopySpecResolver parent) {
            this.parentResolver = parent;
        }

        @Override
        public RelativePath getDestPath() {
            RelativePath parentPath = this.parentResolver == null ? new RelativePath(false, new String[0]) : this.parentResolver.getDestPath();
            if (DefaultCopySpec.this.destDir == null) {
                return parentPath;
            }
            String path = (String)PATH_NOTATION_PARSER.parseNotation(DefaultCopySpec.this.destDir);
            if (path.startsWith("/") || path.startsWith(File.separator)) {
                return RelativePath.parse(false, path);
            }
            return RelativePath.parse(false, parentPath, path);
        }

        @Override
        public FileTree getSource() {
            return DefaultCopySpec.this.fileResolver.resolveFilesAsTree(DefaultCopySpec.this.sourcePaths).matching(this.getPatternSet());
        }

        @Override
        public FileTree getAllSource() {
            final ImmutableList.Builder builder = ImmutableList.builder();
            this.walk((Action<? super CopySpecResolver>)new Action<CopySpecResolver>(){

                public void execute(CopySpecResolver copySpecResolver) {
                    builder.add((Object)copySpecResolver.getSource());
                }
            });
            return DefaultCopySpec.this.fileResolver.compositeFileTree((List<FileTree>)builder.build());
        }

        @Override
        public Collection<? extends Action<? super FileCopyDetails>> getAllCopyActions() {
            if (this.parentResolver == null) {
                return DefaultCopySpec.this.copyActions;
            }
            ArrayList<? extends Action<? super FileCopyDetails>> allActions = new ArrayList<Action<? super FileCopyDetails>>();
            allActions.addAll(this.parentResolver.getAllCopyActions());
            allActions.addAll(DefaultCopySpec.this.copyActions);
            return allActions;
        }

        @Override
        public List<String> getAllIncludes() {
            ArrayList<String> result = new ArrayList<String>();
            if (this.parentResolver != null) {
                result.addAll(this.parentResolver.getAllIncludes());
            }
            result.addAll(DefaultCopySpec.this.patternSet.getIncludes());
            return result;
        }

        @Override
        public List<String> getAllExcludes() {
            ArrayList<String> result = new ArrayList<String>();
            if (this.parentResolver != null) {
                result.addAll(this.parentResolver.getAllExcludes());
            }
            result.addAll(DefaultCopySpec.this.patternSet.getExcludes());
            return result;
        }

        @Override
        public List<Spec<FileTreeElement>> getAllExcludeSpecs() {
            ArrayList<Spec<FileTreeElement>> result = new ArrayList<Spec<FileTreeElement>>();
            if (this.parentResolver != null) {
                result.addAll(this.parentResolver.getAllExcludeSpecs());
            }
            result.addAll(DefaultCopySpec.this.patternSet.getExcludeSpecs());
            return result;
        }

        @Override
        public DuplicatesStrategy getDuplicatesStrategy() {
            if (DefaultCopySpec.this.duplicatesStrategy != null) {
                return DefaultCopySpec.this.duplicatesStrategy;
            }
            if (this.parentResolver != null) {
                return this.parentResolver.getDuplicatesStrategy();
            }
            return DuplicatesStrategy.INCLUDE;
        }

        @Override
        public boolean isCaseSensitive() {
            if (DefaultCopySpec.this.caseSensitive != null) {
                return DefaultCopySpec.this.caseSensitive;
            }
            if (this.parentResolver != null) {
                return this.parentResolver.isCaseSensitive();
            }
            return true;
        }

        @Override
        public Integer getFileMode() {
            if (DefaultCopySpec.this.fileMode != null) {
                return DefaultCopySpec.this.fileMode;
            }
            if (this.parentResolver != null) {
                return this.parentResolver.getFileMode();
            }
            return null;
        }

        @Override
        public Integer getDirMode() {
            if (DefaultCopySpec.this.dirMode != null) {
                return DefaultCopySpec.this.dirMode;
            }
            if (this.parentResolver != null) {
                return this.parentResolver.getDirMode();
            }
            return null;
        }

        @Override
        public boolean getIncludeEmptyDirs() {
            if (DefaultCopySpec.this.includeEmptyDirs != null) {
                return DefaultCopySpec.this.includeEmptyDirs;
            }
            if (this.parentResolver != null) {
                return this.parentResolver.getIncludeEmptyDirs();
            }
            return true;
        }

        @Override
        public List<Spec<FileTreeElement>> getAllIncludeSpecs() {
            ArrayList<Spec<FileTreeElement>> result = new ArrayList<Spec<FileTreeElement>>();
            if (this.parentResolver != null) {
                result.addAll(this.parentResolver.getAllIncludeSpecs());
            }
            result.addAll(DefaultCopySpec.this.patternSet.getIncludeSpecs());
            return result;
        }

        public PatternSet getPatternSet() {
            PatternSet patterns = new PatternSet();
            patterns.setCaseSensitive(this.isCaseSensitive());
            patterns.include(this.getAllIncludes());
            patterns.includeSpecs(this.getAllIncludeSpecs());
            patterns.exclude(this.getAllExcludes());
            patterns.excludeSpecs(this.getAllExcludeSpecs());
            return patterns;
        }

        @Override
        public void walk(Action<? super CopySpecResolver> action) {
            action.execute((Object)this);
            for (CopySpecInternal child : DefaultCopySpec.this.getChildren()) {
                child.buildResolverRelativeToParent(this).walk(action);
            }
        }
    }
}

