/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.dsl.internal.spike;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.gradle.groovy.scripts.internal.AstUtils;
import org.gradle.groovy.scripts.internal.ScriptBlock;
import org.gradle.model.dsl.internal.spike.ModelRegistryDslHelperStatementGenerator;
import org.gradle.model.dsl.internal.spike.ScopeVisitor;

public class GradleModellingLanguageTransformer
extends CompilationUnit.SourceUnitOperation {
    private static final String MODEL = "model";
    private static final List<String> SCRIPT_BLOCK_NAMES = Collections.singletonList("model");

    public void call(SourceUnit source) throws CompilationFailedException {
        ModelRegistryDslHelperStatementGenerator statementGenerator = new ModelRegistryDslHelperStatementGenerator();
        BlockStatement rootStatementBlock = source.getAST().getStatementBlock();
        ListIterator statementsIterator = rootStatementBlock.getStatements().listIterator();
        while (statementsIterator.hasNext()) {
            Statement statement = (Statement)statementsIterator.next();
            ScriptBlock scriptBlock = AstUtils.detectScriptBlock((Statement)statement, SCRIPT_BLOCK_NAMES);
            if (scriptBlock == null) continue;
            statementsIterator.remove();
            ScopeVisitor scopeVisitor = new ScopeVisitor(source, statementGenerator);
            scriptBlock.getClosureExpression().getCode().visit((GroovyCodeVisitor)scopeVisitor);
        }
        rootStatementBlock.addStatements(statementGenerator.getGeneratedStatements());
    }
}

