/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.youtrack;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.tasks.youtrack.YouTrackRepository;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class YouTrackIntellisense {
    public static final Key<YouTrackIntellisense> INTELLISENSE_KEY = Key.create((String)"youtrack.intellisense");
    private static final Logger LOG = Logger.getInstance(YouTrackIntellisense.class);
    public static final String INTELLISENSE_RESOURCE = "/rest/issue/intellisense";
    private static final Map<String, TextAttributes> TEXT_ATTRIBUTES = ContainerUtil.newHashMap((Pair)Pair.create((Object)"field", (Object)DefaultLanguageHighlighterColors.CONSTANT.getDefaultAttributes()), (Pair[])new Pair[]{Pair.create((Object)"keyword", (Object)DefaultLanguageHighlighterColors.KEYWORD.getDefaultAttributes()), Pair.create((Object)"string", (Object)DefaultLanguageHighlighterColors.STRING.getDefaultAttributes()), Pair.create((Object)"error", (Object)HighlighterColors.BAD_CHARACTER.getDefaultAttributes())});
    private static final int CACHE_SIZE = 30;
    private static final Map<Pair<String, Integer>, Response> ourCache = Collections.synchronizedMap(new SizeLimitedCache(30));
    private final YouTrackRepository myRepository;

    private static TextAttributes getAttributeByStyleClass(String styleClass) {
        TextAttributes attr = TEXT_ATTRIBUTES.get(styleClass);
        return attr == null ? HighlighterColors.TEXT.getDefaultAttributes() : attr;
    }

    public List<HighlightRange> fetchHighlighting(String query, int caret) throws Exception {
        LOG.debug("Requesting highlighting");
        return this.fetch(query, caret, true).getHighlightRanges();
    }

    public List<CompletionItem> fetchCompletion(String query, int caret) throws Exception {
        LOG.debug("Requesting completion");
        return this.fetch(query, caret, false).getCompletionItems();
    }

    public YouTrackIntellisense(YouTrackRepository repository) {
        this.myRepository = repository;
    }

    private Response fetch(String query, int caret, boolean ignoreCaret) throws Exception {
        LOG.debug("Query: '" + query + "' caret at: " + caret);
        Pair lookup = Pair.create((Object)query, (Object)caret);
        Response response = null;
        if (ignoreCaret) {
            for (Pair<String, Integer> pair : ourCache.keySet()) {
                if (!((String)pair.getFirst()).equals(query)) continue;
                response = ourCache.get(pair);
                break;
            }
        } else {
            response = ourCache.get(lookup);
        }
        LOG.debug("Cache " + (response != null ? "hit" : "miss"));
        if (response == null) {
            String url = String.format("%s?filter=%s&caret=%d", INTELLISENSE_RESOURCE, URLEncoder.encode(query, "utf-8"), caret);
            long startTime = System.currentTimeMillis();
            response = new Response(this.myRepository.doREST(url, false).getResponseBodyAsStream());
            LOG.debug(String.format("Intellisense request to YouTrack took %d ms to complete", System.currentTimeMillis() - startTime));
            ourCache.put((Pair<String, Integer>)lookup, response);
        }
        return response;
    }

    public YouTrackRepository getRepository() {
        return this.myRepository;
    }

    public static class CompletionItem {
        private TextRange myMatchRange;
        private TextRange myCompletionRange;
        private int myCaretPosition;
        private String myDescription;
        private String mySuffix;
        private String myPrefix;
        private String myOption;
        private String myStyleClass;

        public CompletionItem(Element item) {
            Element match = item.getChild("match");
            this.myMatchRange = new TextRange(Integer.parseInt(match.getAttributeValue("start")), Integer.parseInt(match.getAttributeValue("end")));
            Element completion = item.getChild("completion");
            this.myCompletionRange = new TextRange(Integer.parseInt(completion.getAttributeValue("start")), Integer.parseInt(completion.getAttributeValue("end")));
            this.myDescription = item.getChildText("description");
            this.myOption = item.getChildText("option");
            this.mySuffix = item.getChildText("suffix");
            this.myPrefix = item.getChildText("prefix");
            this.myStyleClass = item.getChildText("styleClass");
            this.myCaretPosition = Integer.valueOf(item.getChildText("caret"));
        }

        public TextRange getMatchRange() {
            return this.myMatchRange;
        }

        public TextRange getCompletionRange() {
            return this.myCompletionRange;
        }

        public int getCaretPosition() {
            return this.myCaretPosition;
        }

        public String getDescription() {
            return this.myDescription;
        }

        public String getSuffix() {
            return StringUtil.notNullize((String)this.mySuffix);
        }

        public String getPrefix() {
            return StringUtil.notNullize((String)this.myPrefix);
        }

        public String getOption() {
            return this.myOption;
        }

        public String getStyleClass() {
            return StringUtil.notNullize((String)this.myStyleClass);
        }

        TextAttributes getTextAttributes() {
            return YouTrackIntellisense.getAttributeByStyleClass(this.myStyleClass);
        }
    }

    public static class HighlightRange {
        private int myStart;
        private int myEnd;
        private String myStyleClass;

        public HighlightRange(Element rangeElement) {
            this.myStart = Integer.valueOf(rangeElement.getChildText("start"));
            this.myEnd = Integer.valueOf(rangeElement.getChildText("end"));
            this.myStyleClass = rangeElement.getChildText("styleClass");
        }

        public int getStart() {
            return this.myStart;
        }

        public int getEnd() {
            return this.myEnd;
        }

        public String getStyleClass() {
            return StringUtil.notNullize((String)this.myStyleClass);
        }

        public TextRange getRange() {
            return new TextRange(this.myStart, this.myEnd);
        }

        public TextRange getTextRange() {
            return TextRange.create((int)this.myStart, (int)this.myEnd);
        }

        public TextAttributes getTextAttributes() {
            return YouTrackIntellisense.getAttributeByStyleClass(this.myStyleClass);
        }
    }

    public static class Response {
        private List<HighlightRange> myHighlightRanges;
        private List<CompletionItem> myCompletionItems;

        public Response(InputStream stream) throws Exception {
            Element root = new SAXBuilder().build(stream).getRootElement();
            TaskUtil.prettyFormatXmlToLog(LOG, root);
            Element highlight = root.getChild("highlight");
            this.myHighlightRanges = ContainerUtil.map((Collection)highlight.getChildren("range"), (Function)new Function<Element, HighlightRange>(){

                public HighlightRange fun(Element range) {
                    return new HighlightRange(range);
                }
            });
            Element suggest = root.getChild("suggest");
            this.myCompletionItems = ContainerUtil.map((Collection)suggest.getChildren("item"), (Function)new Function<Element, CompletionItem>(){

                public CompletionItem fun(Element item) {
                    return new CompletionItem(item);
                }
            });
        }

        public List<HighlightRange> getHighlightRanges() {
            return this.myHighlightRanges;
        }

        public List<CompletionItem> getCompletionItems() {
            return this.myCompletionItems;
        }
    }

    private static class SizeLimitedCache<K, V>
    extends LinkedHashMap<K, V> {
        private final int myMaxSize;

        private SizeLimitedCache(int max) {
            super((int)((double)max / 0.75) + 1, true);
            this.myMaxSize = max;
        }

        protected boolean removeEldestEntry(Map.Entry<K, V> eldest, K key, V value) {
            return this.size() > this.myMaxSize;
        }
    }
}

