/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.trello;

import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.trello.TrelloIconBuilder;
import com.intellij.tasks.trello.model.TrelloCard;
import com.intellij.tasks.trello.model.TrelloCommentAction;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;

public class TrelloTask
extends Task {
    private static final TrelloIconBuilder ourIconBuilder = new TrelloIconBuilder(16);
    private TrelloCard myCard;
    private TaskRepository myRepository;

    public TrelloTask(TrelloCard card, TaskRepository repository) {
        this.myCard = card;
        this.myRepository = repository;
    }

    public String getId() {
        return this.myCard.getId();
    }

    public String getSummary() {
        return this.myCard.getName();
    }

    public String getDescription() {
        return this.myCard.getDescription();
    }

    public Comment[] getComments() {
        List<TrelloCommentAction> comments = this.myCard.getComments();
        return comments.toArray(new Comment[comments.size()]);
    }

    public Icon getIcon() {
        return ourIconBuilder.buildIcon(this.myCard.getColors());
    }

    public TaskType getType() {
        return TaskType.OTHER;
    }

    public Date getUpdated() {
        return this.myCard.getDateLastActivity();
    }

    public Date getCreated() {
        return null;
    }

    public boolean isClosed() {
        return this.myCard.isClosed() || !this.myCard.isVisible();
    }

    public boolean isIssue() {
        return true;
    }

    public String getIssueUrl() {
        return this.myCard.getUrl();
    }

    public String getPresentableName() {
        return this.myCard.getName();
    }

    public TaskRepository getRepository() {
        return this.myRepository;
    }

    public String getNumber() {
        return this.myCard.getIdShort();
    }
}

