/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.trac;

import com.intellij.openapi.util.Comparing;
import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.BaseRepositoryImpl;
import com.intellij.tasks.trac.TracRepositoryType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import icons.TasksIcons;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import org.apache.xmlrpc.CommonsXmlRpcTransport;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcClientRequest;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.XmlRpcTransport;

@Tag(value="Trac")
public class TracRepository
extends BaseRepositoryImpl {
    private String myDefaultSearch = "status!=closed&owner={username}&summary~={query}";
    private Boolean myMaxSupported;

    public Task[] getIssues(String query, int max, long since) throws Exception {
        Transport transport = new Transport();
        return this.getIssues(query, max, transport);
    }

    private Task[] getIssues(String query, int max, Transport transport) throws Exception {
        XmlRpcClient client = this.getRpcClient();
        Vector<Object> result = null;
        String search = this.myDefaultSearch + "&max=" + max;
        if (this.myMaxSupported == null) {
            try {
                this.myMaxSupported = true;
                result = this.runQuery(query, transport, client, search);
            }
            catch (XmlRpcException e) {
                if (e.getMessage().contains("t.max")) {
                    this.myMaxSupported = false;
                }
                throw e;
            }
        }
        if (!this.myMaxSupported.booleanValue()) {
            search = this.myDefaultSearch;
        }
        if (result == null) {
            result = this.runQuery(query, transport, client, search);
        }
        if (result == null) {
            throw new Exception("Cannot connect to " + this.getUrl());
        }
        ArrayList tasks = new ArrayList(max);
        int min = Math.min(max, result.size());
        for (int i = 0; i < min; ++i) {
            Task task = this.getTask((Integer)result.get(i), client, transport);
            ContainerUtil.addIfNotNull(tasks, (Object)task);
        }
        return tasks.toArray(new Task[tasks.size()]);
    }

    private Vector<Object> runQuery(String query, Transport transport, XmlRpcClient client, String search) throws XmlRpcException, IOException {
        if (query != null) {
            search = search.replace("{query}", query);
        }
        search = search.replace("{username}", this.getUsername());
        XmlRpcRequest request = new XmlRpcRequest("ticket.query", new Vector<String>(Arrays.asList(search)));
        return (Vector)client.execute((XmlRpcClientRequest)request, (XmlRpcTransport)transport);
    }

    private XmlRpcClient getRpcClient() throws MalformedURLException {
        return new XmlRpcClient(this.getUrl());
    }

    public Task findTask(String id) throws Exception {
        return this.getTask(Integer.parseInt(id), this.getRpcClient(), new Transport());
    }

    public String getDefaultSearch() {
        return this.myDefaultSearch;
    }

    public void setDefaultSearch(String defaultSearch) {
        this.myDefaultSearch = defaultSearch;
    }

    private Task getTask(int id, XmlRpcClient client, Transport transport) throws IOException, XmlRpcException {
        XmlRpcRequest request = new XmlRpcRequest("ticket.get", new Vector<Integer>(Arrays.asList(id)));
        Object response = client.execute((XmlRpcClientRequest)request, (XmlRpcTransport)transport);
        if (response == null) {
            return null;
        }
        final Vector vector = (Vector)response;
        final Hashtable map = (Hashtable)vector.get(3);
        return new Task(){

            public String getId() {
                return vector.get(0).toString();
            }

            public String getSummary() {
                return (String)map.get("summary");
            }

            public String getDescription() {
                return null;
            }

            public Comment[] getComments() {
                return new Comment[0];
            }

            public Icon getIcon() {
                return TasksIcons.Trac;
            }

            public TaskType getType() {
                TaskType taskType = TaskType.OTHER;
                String type = (String)map.get("type");
                if (type == null) {
                    return taskType;
                }
                if ("Feature".equals(type) || "enhancement".equals(type)) {
                    taskType = TaskType.FEATURE;
                } else if ("Bug".equals(type) || "defect".equals(type) || "error".equals(type)) {
                    taskType = TaskType.BUG;
                } else if ("Exception".equals(type)) {
                    taskType = TaskType.EXCEPTION;
                }
                return taskType;
            }

            public Date getUpdated() {
                return TracRepository.getDate(vector.get(2));
            }

            public Date getCreated() {
                return TracRepository.getDate(vector.get(1));
            }

            public boolean isClosed() {
                return false;
            }

            public boolean isIssue() {
                return true;
            }

            public String getIssueUrl() {
                return null;
            }

            public TaskRepository getRepository() {
                return TracRepository.this;
            }
        };
    }

    private static Date getDate(Object o) {
        return o instanceof Date ? (Date)o : new Date((long)((Integer)o).intValue() * 1000L);
    }

    public TaskRepository.CancellableConnection createCancellableConnection() {
        return new TaskRepository.CancellableConnection(){
            Transport myTransport;

            protected void doTest() throws Exception {
                this.myTransport = new Transport();
                TracRepository.this.getIssues("", 1, this.myTransport);
            }

            public void cancel() {
                this.myTransport.cancel();
            }
        };
    }

    public BaseRepository clone() {
        return new TracRepository(this);
    }

    public TracRepository() {
    }

    public TracRepository(TracRepositoryType repositoryType) {
        super((TaskRepositoryType)repositoryType);
        this.setUrl("http://myserver.com/login/rpc");
        this.myUseHttpAuthentication = true;
    }

    private TracRepository(TracRepository other) {
        super((BaseRepositoryImpl)other);
        this.myDefaultSearch = other.myDefaultSearch;
    }

    public boolean equals(Object o) {
        return super.equals(o) && Comparing.equal((String)((TracRepository)((Object)o)).getDefaultSearch(), (String)this.getDefaultSearch());
    }

    protected int getFeatures() {
        return super.getFeatures() | 1;
    }

    static {
        XmlRpc.setDefaultInputEncoding((String)"UTF-8");
    }

    private class Transport
    extends CommonsXmlRpcTransport {
        public Transport() throws MalformedURLException {
            super(new URL(TracRepository.this.getUrl()), TracRepository.this.getHttpClient());
        }

        void cancel() {
            this.method.abort();
        }
    }
}

