/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.impl.httpclient.ResponseUtil;
import com.intellij.util.text.DateFormatUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.http.HttpResponse;
import org.jdom.Element;

public class TaskUtil {
    private static Pattern ISO8601_DATE_PATTERN = Pattern.compile("(\\d{4}[/-]\\d{2}[/-]\\d{2})(?:[ T](\\d{2}:\\d{2}:\\d{2})(.\\d{3,})?(?:\\s?([+-]\\d{2}:\\d{2}|[+-]\\d{4}|[+-]\\d{2}|Z))?)?");

    private TaskUtil() {
    }

    public static String formatTask(Task task, String format) {
        return format.replace("{id}", task.getId()).replace("{number}", task.getNumber()).replace("{project}", StringUtil.notNullize((String)task.getProject())).replace("{summary}", task.getSummary());
    }

    public static String getChangeListComment(Task task) {
        TaskRepository repository = task.getRepository();
        if (repository == null || !repository.isShouldFormatCommitMessage()) {
            return null;
        }
        return TaskUtil.formatTask(task, repository.getCommitMessageFormat());
    }

    public static String getTrimmedSummary(Task task) {
        String text = task.isIssue() ? task.getId() + ": " + task.getSummary() : task.getSummary();
        return StringUtil.first((String)text, (int)60, (boolean)true);
    }

    public static Date parseDate(String s) {
        String milliseconds;
        Matcher m = ISO8601_DATE_PATTERN.matcher(s);
        if (!m.matches()) {
            return null;
        }
        String datePart = m.group(1).replace('/', '-');
        String timePart = m.group(2);
        if (timePart == null) {
            timePart = "00:00:00";
        }
        milliseconds = (milliseconds = m.group(3)) == null ? "000" : milliseconds.substring(1, 4);
        String timezone = m.group(4);
        if (timezone == null || timezone.equals("Z")) {
            timezone = "+0000";
        } else if (timezone.length() == 3) {
            timezone = timezone + "00";
        } else if (timezone.length() == 6) {
            timezone = timezone.substring(0, 3) + timezone.substring(4, 6);
        }
        String canonicalForm = String.format("%sT%s.%s%s", datePart, timePart, milliseconds, timezone);
        try {
            return DateFormatUtil.ISO8601_DATE_FORMAT.parse(canonicalForm);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String formatDate(Date date) {
        return DateFormatUtil.ISO8601_DATE_FORMAT.format(date);
    }

    public static boolean tasksEqual(Task t1, Task t2) {
        if (!t1.getId().equals(t2.getId())) {
            return false;
        }
        if (!t1.getSummary().equals(t2.getSummary())) {
            return false;
        }
        if (t1.isClosed() != t2.isClosed()) {
            return false;
        }
        if (t1.isIssue() != t2.isIssue()) {
            return false;
        }
        if (!Comparing.equal((Object)t1.getState(), (Object)t2.getState())) {
            return false;
        }
        if (!Comparing.equal((Object)t1.getType(), (Object)t2.getType())) {
            return false;
        }
        if (!Comparing.equal((String)t1.getDescription(), (String)t2.getDescription())) {
            return false;
        }
        if (!Comparing.equal((Object)t1.getCreated(), (Object)t2.getCreated())) {
            return false;
        }
        if (!Comparing.equal((Object)t1.getUpdated(), (Object)t2.getUpdated())) {
            return false;
        }
        if (!Comparing.equal((String)t1.getIssueUrl(), (String)t2.getIssueUrl())) {
            return false;
        }
        if (!Comparing.equal((Object[])t1.getComments(), (Object[])t2.getComments())) {
            return false;
        }
        if (!Comparing.equal((Object)t1.getIcon(), (Object)t2.getIcon())) {
            return false;
        }
        if (!Comparing.equal((String)t1.getCustomIcon(), (String)t2.getCustomIcon())) {
            return false;
        }
        return Comparing.equal((Object)t1.getRepository(), (Object)t2.getRepository());
    }

    public static boolean tasksEqual(List<? extends Task> tasks1, List<? extends Task> tasks2) {
        if (tasks1.size() != tasks2.size()) {
            return false;
        }
        for (int i = 0; i < tasks1.size(); ++i) {
            if (TaskUtil.tasksEqual(tasks1.get(i), tasks2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean tasksEqual(Task[] task1, Task[] task2) {
        return TaskUtil.tasksEqual(Arrays.asList(task1), Arrays.asList(task2));
    }

    public static void prettyFormatXmlToLog(Logger logger, Element element) {
        if (logger.isDebugEnabled()) {
            logger.debug("\n" + JDOMUtil.createOutputter((String)"\n").outputString(element));
        }
    }

    public static void prettyFormatXmlToLog(Logger logger, InputStream xml) {
        if (logger.isDebugEnabled()) {
            try {
                logger.debug("\n" + JDOMUtil.createOutputter((String)"\n").outputString(JDOMUtil.loadDocument((InputStream)xml)));
            }
            catch (Exception e) {
                logger.debug((Throwable)e);
            }
        }
    }

    public static void prettyFormatXmlToLog(Logger logger, String xml) {
        if (logger.isDebugEnabled()) {
            try {
                logger.debug("\n" + JDOMUtil.createOutputter((String)"\n").outputString(JDOMUtil.loadDocument((CharSequence)xml)));
            }
            catch (Exception e) {
                logger.debug((Throwable)e);
            }
        }
    }

    public static void prettyFormatJsonToLog(Logger logger, String json) {
        if (logger.isDebugEnabled()) {
            try {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                logger.debug("\n" + gson.toJson((JsonElement)gson.fromJson(json, JsonElement.class)));
            }
            catch (JsonSyntaxException e) {
                logger.debug("Malformed JSON\n" + json);
            }
        }
    }

    public static void prettyFormatJsonToLog(Logger logger, JsonElement json) {
        if (logger.isDebugEnabled()) {
            try {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                logger.debug("\n" + gson.toJson(json));
            }
            catch (JsonSyntaxException e) {
                logger.debug("Malformed JSON\n" + json);
            }
        }
    }

    public static void prettyFormatResponseToLog(Logger logger, HttpMethod response) {
        if (logger.isDebugEnabled() && response.hasBeenUsed()) {
            try {
                String contentType;
                String content = ResponseUtil.getResponseContentAsString(response);
                Header header = response.getRequestHeader("Content-Type");
                String string = contentType = header == null ? "text/plain" : header.getElements()[0].getName().toLowerCase(Locale.ENGLISH);
                if (contentType.contains("xml")) {
                    TaskUtil.prettyFormatXmlToLog(logger, content);
                } else if (contentType.contains("json")) {
                    TaskUtil.prettyFormatJsonToLog(logger, content);
                } else {
                    logger.debug(content);
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
    }

    public static void prettyFormatResponseToLog(Logger logger, HttpResponse response) {
        if (logger.isDebugEnabled()) {
            try {
                String contentType;
                String content = ResponseUtil.getResponseContentAsString(response);
                org.apache.http.Header header = response.getEntity().getContentType();
                String string = contentType = header == null ? "text/plain" : header.getElements()[0].getName().toLowerCase(Locale.ENGLISH);
                if (contentType.contains("xml")) {
                    TaskUtil.prettyFormatXmlToLog(logger, content);
                } else if (contentType.contains("json")) {
                    TaskUtil.prettyFormatJsonToLog(logger, content);
                } else {
                    logger.debug(content);
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
    }

    public static String encodeUrl(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 is not supported");
        }
    }

    public static boolean isStateSupported(TaskRepository repository, TaskState state) {
        if (repository == null || !repository.isSupported(8)) {
            return false;
        }
        return repository.getRepositoryType().getPossibleTaskStates().contains(state);
    }
}

