/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.EditChangelistSupport;
import com.intellij.tasks.ChangeListInfo;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.actions.TaskAutoCompletionListProvider;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TextFieldWithAutoCompletionContributor;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.Consumer;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class TaskChangelistSupport
implements EditChangelistSupport {
    private final Project myProject;
    private final TaskManagerImpl myTaskManager;

    public TaskChangelistSupport(Project project, TaskManagerImpl taskManager) {
        this.myProject = project;
        this.myTaskManager = taskManager;
    }

    public void installSearch(EditorTextField name, EditorTextField comment) {
        Document document = name.getDocument();
        TaskAutoCompletionListProvider completionProvider = new TaskAutoCompletionListProvider(this.myProject);
        TextFieldWithAutoCompletionContributor.installCompletion((Document)document, (Project)this.myProject, (TextFieldWithAutoCompletionListProvider)completionProvider, (boolean)false);
    }

    public Consumer<LocalChangeList> addControls(JPanel bottomPanel, final LocalChangeList initial) {
        final JCheckBox checkBox = new JCheckBox("Track context");
        checkBox.setMnemonic('t');
        checkBox.setToolTipText("Reload context (e.g. open editors) when changelist is set active");
        checkBox.setSelected(initial == null ? this.myTaskManager.getState().trackContextForNewChangelist : this.myTaskManager.getAssociatedTask(initial) != null);
        bottomPanel.add(checkBox);
        return new Consumer<LocalChangeList>(){

            public void consume(LocalChangeList changeList) {
                if (initial == null) {
                    ((TaskChangelistSupport)TaskChangelistSupport.this).myTaskManager.getState().trackContextForNewChangelist = checkBox.isSelected();
                    if (checkBox.isSelected()) {
                        TaskChangelistSupport.this.myTaskManager.trackContext(changeList);
                    } else {
                        TaskChangelistSupport.this.myTaskManager.getActiveTask().addChangelist(new ChangeListInfo(changeList));
                    }
                } else {
                    LocalTask associatedTask = TaskChangelistSupport.this.myTaskManager.getAssociatedTask(changeList);
                    if (checkBox.isSelected()) {
                        if (associatedTask == null) {
                            TaskChangelistSupport.this.myTaskManager.trackContext(changeList);
                        }
                    } else if (associatedTask != null) {
                        TaskChangelistSupport.this.myTaskManager.removeTask(associatedTask);
                    }
                }
            }
        };
    }

    public void changelistCreated(LocalChangeList changeList) {
    }
}

