/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.context;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.tasks.context.WorkingContextProvider;
import com.intellij.util.xmlb.Accessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import java.util.Collection;
import org.jdom.Element;

public class XDebuggerBreakpointsContextProvider
extends WorkingContextProvider {
    private final XBreakpointManagerImpl myBreakpointManager;

    public XDebuggerBreakpointsContextProvider(XDebuggerManager xDebuggerManager) {
        this.myBreakpointManager = (XBreakpointManagerImpl)xDebuggerManager.getBreakpointManager();
    }

    public String getId() {
        return "xDebugger";
    }

    public String getDescription() {
        return "XDebugger breakpoints";
    }

    public void saveContext(Element toElement) throws WriteExternalException {
        XBreakpointManagerImpl.BreakpointManagerState state = this.myBreakpointManager.getState();
        Element serialize = XmlSerializer.serialize((Object)state, (SerializationFilter)new SerializationFilter(){

            public boolean accepts(Accessor accessor, Object bean) {
                return accessor.read(bean) != null;
            }
        });
        toElement.addContent((Collection)serialize.removeContent());
    }

    public void loadContext(Element fromElement) throws InvalidDataException {
        XBreakpointManagerImpl.BreakpointManagerState state = (XBreakpointManagerImpl.BreakpointManagerState)XmlSerializer.deserialize((Element)fromElement, XBreakpointManagerImpl.BreakpointManagerState.class);
        this.myBreakpointManager.loadState(state);
    }

    public void clearContext() {
        XBreakpointBase[] breakpoints;
        for (final XBreakpointBase breakpoint : breakpoints = this.myBreakpointManager.getAllBreakpoints()) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    XDebuggerBreakpointsContextProvider.this.myBreakpointManager.removeBreakpoint((XBreakpoint)breakpoint);
                }
            });
        }
    }
}

