/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.bugzilla;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskBundle;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.bugzilla.BugzillaTask;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.BaseRepositoryImpl;
import com.intellij.tasks.impl.RequestFailedException;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.xmlb.annotations.Tag;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.xmlrpc.CommonsXmlRpcTransport;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcClientException;
import org.apache.xmlrpc.XmlRpcClientRequest;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.XmlRpcTransport;

@Tag(value="Bugzilla")
public class BugzillaRepository
extends BaseRepositoryImpl {
    private static final Logger LOG = Logger.getInstance(BugzillaRepository.class);
    public static final Pattern TIME_SPENT_PATTERN = Pattern.compile("([0-9]+)d ([0-9]+)h ([0-9]+)m");
    private Version myVersion;
    private boolean myAuthenticated;
    private String myAuthenticationToken;
    private String myProductName = "";
    private String myComponentName = "";

    public BugzillaRepository() {
    }

    public BugzillaRepository(TaskRepositoryType type) {
        super(type);
        this.setUseHttpAuthentication(false);
        this.setUrl("http://myserver.com/xmlrpc.cgi");
    }

    public BugzillaRepository(BugzillaRepository other) {
        super((BaseRepositoryImpl)other);
        this.myProductName = other.myProductName;
        this.myComponentName = other.myComponentName;
    }

    public BaseRepository clone() {
        return new BugzillaRepository(this);
    }

    public Task[] getIssues(String query, int offset, int limit, boolean withClosed, ProgressIndicator cancelled) throws Exception {
        Hashtable response = (Hashtable)this.createIssueSearchRequest(query, offset, limit, withClosed).execute();
        Vector bugs = (Vector)response.get("bugs");
        return (Task[])ContainerUtil.map2Array((Collection)bugs, BugzillaTask.class, (Function)new Function<Hashtable<String, Object>, BugzillaTask>(){

            public BugzillaTask fun(Hashtable<String, Object> hashTable) {
                return new BugzillaTask(hashTable, BugzillaRepository.this);
            }
        });
    }

    private BugzillaXmlRpcRequest createIssueSearchRequest(String query, int offset, int limit, boolean withClosed) throws Exception {
        return new BugzillaXmlRpcRequest("Bug.search").requireAuthentication(true).withParameter("summary", StringUtil.isNotEmpty((String)query) ? BugzillaRepository.newVector(query.split("\\s+")) : null).withParameter("product", StringUtil.nullize((String)this.myProductName)).withParameter("component", StringUtil.nullize((String)this.myComponentName)).withParameter("offset", offset).withParameter("limit", limit).withParameter("assigned_to", this.getUsername()).withParameter("resolution", !withClosed ? "" : null);
    }

    public Task findTask(String id) throws Exception {
        Hashtable response;
        try {
            response = (Hashtable)new BugzillaXmlRpcRequest("Bug.get").requireAuthentication(true).withParameter("ids", BugzillaRepository.newVector(id)).execute();
        }
        catch (XmlRpcException e) {
            if (e.code == 101 && e.getMessage().contains("does not exist")) {
                return null;
            }
            throw e;
        }
        Vector bugs = (Vector)response.get("bugs");
        if (bugs == null || bugs.isEmpty()) {
            return null;
        }
        return new BugzillaTask((Hashtable)bugs.get(0), this);
    }

    private void ensureVersionDiscovered() throws Exception {
        if (this.myVersion == null) {
            Hashtable result = (Hashtable)new BugzillaXmlRpcRequest("Bugzilla.version").execute();
            if (result == null) {
                throw new RequestFailedException(TaskBundle.message("bugzilla.failure.no.version", new Object[0]));
            }
            String version = (String)result.get("version");
            String[] parts = version.split("\\.", 3);
            this.myVersion = new Version(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
            if (this.myVersion.lessThan(Integer.valueOf(3), Integer.valueOf(4))) {
                throw new RequestFailedException("Bugzilla before 3.4 is not supported");
            }
        }
    }

    private void ensureUserAuthenticated() throws Exception {
        this.ensureVersionDiscovered();
        if (!this.myAuthenticated) {
            Hashtable response = (Hashtable)new BugzillaXmlRpcRequest("User.login").withParameter("login", this.getUsername()).withParameter("password", this.getPassword()).execute();
            this.myAuthenticated = true;
            this.myAuthenticationToken = (String)response.get("token");
        }
    }

    public void setTaskState(Task task, TaskState state) throws Exception {
        BugzillaXmlRpcRequest request = new BugzillaXmlRpcRequest("Bug.update").requireAuthentication(true).withParameter("ids", BugzillaRepository.newVector(task.getId()));
        switch (state) {
            case IN_PROGRESS: {
                request.withParameter("status", "IN_PROGRESS");
                break;
            }
            case RESOLVED: {
                request.withParameter("status", "RESOLVED").withParameter("resolution", "FIXED");
                break;
            }
            default: {
                return;
            }
        }
        request.execute();
    }

    public void updateTimeSpent(LocalTask task, String timeSpent, String comment) throws Exception {
        LOG.debug(String.format("Last post: %s, time spent from last: %s, time spent: %s", task.getLastPost(), task.getTimeSpentFromLastPost(), timeSpent));
        Matcher matcher = TIME_SPENT_PATTERN.matcher(timeSpent);
        if (matcher.find()) {
            int days = Integer.valueOf(matcher.group(1));
            int hours = Integer.valueOf(matcher.group(2));
            int minutes = Integer.valueOf(matcher.group(3));
            BugzillaXmlRpcRequest request = new BugzillaXmlRpcRequest("Bug.update").requireAuthentication(true).withParameter("ids", BugzillaRepository.newVector(task.getId())).withParameter("work_time", (double)(days * 24 + hours) + (double)minutes / 60.0);
            if (!StringUtil.isEmptyOrSpaces((String)comment)) {
                request.withParameter("comment", BugzillaRepository.newHashTable("body", comment, "is_private", false));
            }
            request.execute();
        } else {
            LOG.error("Illegal time spent format: " + timeSpent);
        }
    }

    public Pair<List<String>, List<String>> fetchProductAndComponentNames() throws Exception {
        Hashtable productIdsResponse = (Hashtable)new BugzillaXmlRpcRequest("Product.get_selectable_products").requireAuthentication(true).execute();
        Hashtable productInfoResponse = (Hashtable)new BugzillaXmlRpcRequest("Product.get").requireAuthentication(true).withParameter("ids", productIdsResponse.get("ids")).execute();
        ArrayList<String> productNames = new ArrayList<String>();
        ArrayList<String> componentNames = new ArrayList<String>();
        for (Hashtable info : (Vector)productInfoResponse.get("products")) {
            productNames.add((String)info.get("name"));
            if (this.myVersion == null || !this.myVersion.isOrGreaterThan(Integer.valueOf(4), Integer.valueOf(2))) continue;
            for (Hashtable component : (Vector)info.get("components")) {
                componentNames.add((String)component.get("name"));
            }
        }
        return Pair.create(productNames, componentNames);
    }

    public TaskRepository.CancellableConnection createCancellableConnection() {
        return new TaskRepository.CancellableConnection(){
            BugzillaXmlRpcRequest myRequest;

            protected void doTest() throws Exception {
                BugzillaRepository.this.myVersion = null;
                BugzillaRepository.this.myAuthenticated = false;
                BugzillaRepository.this.myAuthenticationToken = null;
                this.myRequest = BugzillaRepository.this.createIssueSearchRequest(null, 0, 1, true);
                this.myRequest.execute();
            }

            public void cancel() {
                this.myRequest.cancel();
            }
        };
    }

    private static <T> Vector<T> newVector(T ... elements) {
        return new Vector<T>(Arrays.asList(elements));
    }

    private static <K, V> Hashtable<K, V> newHashTable(Object ... pairs) {
        assert (pairs.length % 2 == 0);
        Hashtable<Object, Object> table = new Hashtable<Object, Object>();
        for (int i = 0; i < pairs.length; i += 2) {
            if (pairs[i + 1] == null) continue;
            table.put(pairs[i], pairs[i + 1]);
        }
        return table;
    }

    public String extractId(String taskName) {
        String id = taskName.trim();
        return id.matches("\\d+") ? id : null;
    }

    public boolean isConfigured() {
        return super.isConfigured() && StringUtil.isNotEmpty((String)this.getUsername()) && StringUtil.isNotEmpty((String)this.getPassword());
    }

    protected int getFeatures() {
        int features = super.getFeatures();
        if (this.myVersion != null && this.myVersion.isOrGreaterThan(Integer.valueOf(4), Integer.valueOf(0))) {
            return features | 8 | 4;
        }
        return features;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof BugzillaRepository)) {
            return false;
        }
        BugzillaRepository repository = (BugzillaRepository)((Object)o);
        if (!Comparing.equal((String)this.myProductName, (String)repository.getProductName())) {
            return false;
        }
        return Comparing.equal((String)this.myComponentName, (String)repository.getComponentName());
    }

    public String getProductName() {
        return this.myProductName;
    }

    public void setProductName(String productName) {
        this.myProductName = productName;
    }

    public String getComponentName() {
        return this.myComponentName;
    }

    public void setComponentName(String componentName) {
        this.myComponentName = componentName;
    }

    private class BugzillaXmlRpcRequest {
        private final String myMethodName;
        private boolean myRequireAuthentication;
        private final HashMap<String, Object> myParameters = new HashMap();
        private final Transport myTransport;

        public BugzillaXmlRpcRequest(String methodName) throws MalformedURLException {
            this.myMethodName = methodName;
            this.myTransport = new Transport();
        }

        public BugzillaXmlRpcRequest withParameter(String name, Object value) {
            if (value != null) {
                this.myParameters.put((Object)name, value);
            }
            return this;
        }

        public BugzillaXmlRpcRequest requireAuthentication(boolean require) {
            this.myRequireAuthentication = require;
            return this;
        }

        public void cancel() {
            this.myTransport.cancel();
        }

        public <T> T execute() throws Exception {
            if (this.myRequireAuthentication) {
                BugzillaRepository.this.ensureUserAuthenticated();
                if (BugzillaRepository.this.myVersion.isOrGreaterThan(Integer.valueOf(4), Integer.valueOf(4)) && BugzillaRepository.this.myAuthenticationToken != null) {
                    this.myParameters.put((Object)"Bugzilla_token", (Object)BugzillaRepository.this.myAuthenticationToken);
                }
            }
            Vector<Hashtable<String, Object>> parameters = new Vector<Hashtable<String, Object>>();
            parameters.add(new Hashtable<String, Object>((Map<String, Object>)this.myParameters));
            try {
                return (T)new XmlRpcClient(BugzillaRepository.this.getUrl()).execute((XmlRpcClientRequest)new XmlRpcRequest(this.myMethodName, parameters), (XmlRpcTransport)this.myTransport);
            }
            catch (XmlRpcClientException e) {
                if (e.getMessage().equals("Error decoding XML-RPC response")) {
                    throw new RequestFailedException(TaskBundle.message("bugzilla.failure.malformed.response", new Object[0]), e);
                }
                throw e;
            }
        }

        private class Transport
        extends CommonsXmlRpcTransport {
            public Transport() throws MalformedURLException {
                super(new URL(BugzillaRepository.this.getUrl()), BugzillaRepository.this.getHttpClient());
            }

            public void cancel() {
                this.method.abort();
            }
        }
    }
}

