/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiManager;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.actions.GotoTaskAction;
import com.intellij.tasks.actions.TaskSearchSupport;
import com.intellij.tasks.doc.TaskPsiElement;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

class TaskItemProvider
implements ChooseByNameItemProvider,
Disposable {
    private static final Logger LOG = Logger.getInstance(TaskItemProvider.class);
    private static final int DELAY_PERIOD = 200;
    private final Project myProject;
    private int myCurrentOffset = 0;
    private boolean myOldEverywhere = false;
    private String myOldPattern = "";
    private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    private final AtomicReference<Future<List<Task>>> myFutureReference = new AtomicReference();

    public TaskItemProvider(Project project) {
        this.myProject = project;
    }

    public List<String> filterNames(ChooseByNameBase base, String[] names, String pattern) {
        return ContainerUtil.emptyList();
    }

    public boolean filterElements(ChooseByNameBase base, final String pattern, final boolean everywhere, final ProgressIndicator cancelled, Processor<Object> consumer) {
        GotoTaskAction.CREATE_NEW_TASK_ACTION.setTaskName(pattern);
        if (!consumer.process((Object)GotoTaskAction.CREATE_NEW_TASK_ACTION)) {
            return false;
        }
        TaskManager taskManager = TaskManager.getManager((Project)this.myProject);
        List allCachedAndLocalTasks = ContainerUtil.concat((List)taskManager.getCachedIssues(), (List)taskManager.getLocalTasks());
        List<Task> filteredCachedAndLocalTasks = TaskSearchSupport.getLocalAndCachedTasks(taskManager, pattern, everywhere);
        if (!this.processTasks(filteredCachedAndLocalTasks, consumer, cancelled)) {
            return false;
        }
        if (filteredCachedAndLocalTasks.size() >= base.getMaximumListSizeLimit()) {
            return true;
        }
        FutureTask<List<Task>> future = new FutureTask<List<Task>>(new Callable<List<Task>>(){

            @Override
            public List<Task> call() throws Exception {
                return TaskItemProvider.this.fetchFromServer(pattern, everywhere, cancelled);
            }
        });
        Future oldFuture = this.myFutureReference.getAndSet(future);
        if (oldFuture != null) {
            LOG.debug("Cancelling existing task");
            oldFuture.cancel(true);
        }
        if (this.myAlarm.isDisposed()) {
            return false;
        }
        this.myAlarm.addRequest(future, oldFuture == null && pattern.length() > 5 ? 0 : 200);
        try {
            List<Task> tasks;
            while (true) {
                try {
                    tasks = future.get(10L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException ignore) {
                    if (!base.hasPostponedAction()) continue;
                    future.cancel(true);
                    return true;
                }
                break;
            }
            this.myFutureReference.compareAndSet(future, null);
            tasks.removeAll(allCachedAndLocalTasks);
            return this.processTasks(tasks, consumer, cancelled);
        }
        catch (InterruptedException interrupted) {
            Thread.interrupted();
        }
        catch (CancellationException e) {
            LOG.debug("Task cancelled");
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ProcessCanceledException) {
                LOG.debug("Task cancelled via progress indicator");
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new RuntimeException("Unknown checked exception", cause);
        }
        return false;
    }

    private List<Task> fetchFromServer(String pattern, boolean everywhere, ProgressIndicator cancelled) {
        int limit;
        int offset;
        if (!this.myOldPattern.equals(pattern)) {
            offset = 0;
            this.myCurrentOffset = 0;
            limit = 20;
        } else if (this.myOldEverywhere != everywhere) {
            offset = 0;
            this.myCurrentOffset = limit = this.myCurrentOffset + 20;
        } else {
            offset = this.myCurrentOffset;
            limit = 20;
            this.myCurrentOffset += 20;
        }
        List<Task> tasks = TaskSearchSupport.getRepositoriesTasks(TaskManager.getManager((Project)this.myProject), pattern, offset, limit, true, everywhere, cancelled);
        this.myOldEverywhere = everywhere;
        this.myOldPattern = pattern;
        return tasks;
    }

    private boolean processTasks(List<Task> tasks, Processor<Object> consumer, ProgressIndicator cancelled) {
        if (!tasks.isEmpty() && !consumer.process((Object)"non-prefix matches:")) {
            return false;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (Task task : tasks) {
            cancelled.checkCanceled();
            if (consumer.process((Object)new TaskPsiElement(psiManager, task))) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        Future<List<Task>> future = this.myFutureReference.get();
        if (future != null) {
            future.cancel(true);
        }
    }
}

