/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.Stack;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Properties;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.gradle.GradleScript;
import org.gradle.wrapper.WrapperConfiguration;
import org.jetbrains.plugins.gradle.util.GradleLog;

public class GradleUtil {
    private static final String LAST_USED_GRADLE_HOME_KEY = "last.used.gradle.home";

    private GradleUtil() {
    }

    public static FileChooserDescriptor getGradleProjectFileChooserDescriptor() {
        return FileChooserDescriptorFactory.createSingleFileDescriptor((String)"gradle");
    }

    public static FileChooserDescriptor getGradleHomeFileChooserDescriptor() {
        return FileChooserDescriptorFactory.createSingleFolderDescriptor();
    }

    public static boolean isGradleDefaultWrapperFilesExist(String gradleProjectPath) {
        return GradleUtil.getWrapperConfiguration(gradleProjectPath) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WrapperConfiguration getWrapperConfiguration(String gradleProjectPath) {
        File wrapperPropertiesFile = GradleUtil.findDefaultWrapperPropertiesFile(gradleProjectPath);
        if (wrapperPropertiesFile == null) {
            return null;
        }
        WrapperConfiguration wrapperConfiguration = new WrapperConfiguration();
        Properties props = new Properties();
        BufferedReader reader = null;
        try {
            String distPathBase;
            reader = new BufferedReader(new FileReader(wrapperPropertiesFile));
            props.load(reader);
            String distributionUrl = props.getProperty("distributionUrl");
            if (StringUtil.isEmpty((String)distributionUrl)) {
                throw new ExternalSystemException("Wrapper 'distributionUrl' property does not exist!");
            }
            wrapperConfiguration.setDistribution(new URI(distributionUrl));
            String distributionPath = props.getProperty("distributionPath");
            if (!StringUtil.isEmpty((String)distributionPath)) {
                wrapperConfiguration.setDistributionPath(distributionPath);
            }
            if (!StringUtil.isEmpty((String)(distPathBase = props.getProperty("distributionBase")))) {
                wrapperConfiguration.setDistributionBase(distPathBase);
            }
            WrapperConfiguration wrapperConfiguration2 = wrapperConfiguration;
            return wrapperConfiguration2;
        }
        catch (Exception e) {
            GradleLog.LOG.warn(String.format("I/O exception on reading gradle wrapper properties file at '%s'", wrapperPropertiesFile.getAbsolutePath()), (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    public static String getConfigPath(GradleProject subProject, String rootProjectPath) {
        try {
            File file;
            GradleScript script = subProject.getBuildScript();
            if (script != null && (file = script.getSourceFile()) != null) {
                if (file.isFile()) {
                    file = file.getParentFile();
                }
                return ExternalSystemApiUtil.toCanonicalPath((String)file.getCanonicalPath());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        File rootProjectParent = new File(rootProjectPath);
        StringBuilder buffer = new StringBuilder(FileUtil.toCanonicalPath((String)rootProjectParent.getAbsolutePath()));
        Stack stack = ContainerUtilRt.newStack();
        for (GradleProject p = subProject; p != null; p = p.getParent()) {
            stack.push((Object)p.getName());
        }
        stack.pop();
        while (!stack.isEmpty()) {
            buffer.append('/').append((String)stack.pop());
        }
        return buffer.toString();
    }

    public static String getLastUsedGradleHome() {
        return PropertiesComponent.getInstance().getValue(LAST_USED_GRADLE_HOME_KEY, "");
    }

    public static void storeLastUsedGradleHome(String gradleHomePath) {
        if (gradleHomePath != null) {
            PropertiesComponent.getInstance().setValue(LAST_USED_GRADLE_HOME_KEY, gradleHomePath);
        }
    }

    public static File findDefaultWrapperPropertiesFile(String gradleProjectPath) {
        if (gradleProjectPath == null) {
            return null;
        }
        File file = new File(gradleProjectPath);
        File gradleDir = file.isFile() ? new File(file.getParentFile(), "gradle") : new File(file, "gradle");
        if (!gradleDir.isDirectory()) {
            return null;
        }
        File wrapperDir = new File(gradleDir, "wrapper");
        if (!wrapperDir.isDirectory()) {
            return null;
        }
        Object[] candidates = wrapperDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File candidate) {
                return candidate.isFile() && candidate.getName().endsWith(".properties");
            }
        });
        if (candidates == null) {
            GradleLog.LOG.warn("No *.properties file is found at the gradle wrapper directory " + wrapperDir.getAbsolutePath());
            return null;
        }
        if (candidates.length != 1) {
            GradleLog.LOG.warn(String.format("%d *.properties files instead of one have been found at the wrapper directory (%s): %s", candidates.length, wrapperDir.getAbsolutePath(), Arrays.toString(candidates)));
            return null;
        }
        return candidates[0];
    }
}

