/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.resolve.dsl;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.plugins.gradle.service.resolve.GradleResolverUtil;
import org.jetbrains.plugins.groovy.highlighter.GroovySyntaxHighlighter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class GradleDslAnnotator
implements Annotator {
    public void annotate(PsiElement element, AnnotationHolder holder) {
        if (element instanceof GrReferenceExpression) {
            GrReferenceExpression referenceExpression = (GrReferenceExpression)element;
            GrExpression qualifier = ResolveUtil.getSelfOrWithQualifier((GrReferenceExpression)referenceExpression);
            if (qualifier == null) {
                return;
            }
            if (qualifier instanceof GrReferenceExpression && ((GrReferenceExpression)qualifier).resolve() instanceof PsiClass) {
                return;
            }
            PsiType psiType = GradleResolverUtil.getTypeOf(qualifier);
            if (psiType == null) {
                return;
            }
            if (InheritanceUtil.isInheritor((PsiType)psiType, (String)"org.gradle.api.NamedDomainObjectCollection")) {
                PsiClass containerClass;
                GroovyPsiManager psiManager = GroovyPsiManager.getInstance((Project)element.getProject());
                PsiClass defaultGroovyMethodsClass = psiManager.findClassWithCache("org.codehaus.groovy.runtime.DefaultGroovyMethods", element.getResolveScope());
                if (GradleResolverUtil.canBeMethodOf(referenceExpression.getReferenceName(), defaultGroovyMethodsClass)) {
                    return;
                }
                String qualifiedName = TypesUtil.getQualifiedName((PsiType)psiType);
                PsiClass psiClass = containerClass = qualifiedName != null ? psiManager.findClassWithCache(qualifiedName, element.getResolveScope()) : null;
                if (GradleResolverUtil.canBeMethodOf(referenceExpression.getReferenceName(), containerClass)) {
                    return;
                }
                PsiElement nameElement = referenceExpression.getReferenceNameElement();
                if (nameElement != null) {
                    holder.createInfoAnnotation(nameElement, null).setTextAttributes(GroovySyntaxHighlighter.MAP_KEY);
                }
            }
        }
    }
}

