/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.wizard;

import com.intellij.externalSystem.JavaProjectData;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkUtil;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.wizard.AbstractExternalProjectImportBuilder;
import com.intellij.openapi.externalSystem.service.settings.AbstractImportFromExternalSystemControl;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import icons.GradleIcons;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.plugins.gradle.service.settings.ImportFromGradleControl;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleProjectImportBuilder
extends AbstractExternalProjectImportBuilder<ImportFromGradleControl> {
    public GradleProjectImportBuilder(ProjectDataManager dataManager) {
        super(dataManager, (AbstractImportFromExternalSystemControl)new ImportFromGradleControl(), GradleConstants.SYSTEM_ID);
    }

    public String getName() {
        return GradleBundle.message("gradle.name", new Object[0]);
    }

    public Icon getIcon() {
        return GradleIcons.Gradle;
    }

    protected void doPrepare(WizardContext context) {
        String pathToUse = this.getFileToImport();
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(pathToUse);
        if (file != null && file.isDirectory()) {
            pathToUse = new File(pathToUse, "build.gradle").getAbsolutePath();
        }
        ImportFromGradleControl importFromGradleControl = (ImportFromGradleControl)this.getControl(context.getProject());
        importFromGradleControl.setLinkedProjectPath(pathToUse);
        Pair sdkPair = ExternalSystemJdkUtil.getAvailableJdk((Project)context.getProject());
        if (sdkPair != null && !"#JAVA_INTERNAL".equals(sdkPair.first)) {
            ((GradleProjectSettings)importFromGradleControl.getProjectSettings()).setGradleJvm((String)sdkPair.first);
        }
    }

    protected void beforeCommit(DataNode<ProjectData> dataNode, Project project) {
        LanguageLevelProjectExtension languageLevelExtension;
        if (!ExternalSystemApiUtil.isNewProjectConstruction()) {
            return;
        }
        DataNode javaProjectNode = ExternalSystemApiUtil.find(dataNode, (Key)JavaProjectData.KEY);
        if (javaProjectNode == null) {
            return;
        }
        LanguageLevel externalLanguageLevel = ((JavaProjectData)javaProjectNode.getData()).getLanguageLevel();
        if (externalLanguageLevel != (languageLevelExtension = LanguageLevelProjectExtension.getInstance((Project)project)).getLanguageLevel()) {
            languageLevelExtension.setLanguageLevel(externalLanguageLevel);
        }
    }

    protected void applyExtraSettings(WizardContext context) {
        DataNode node = this.getExternalProjectNode();
        if (node == null) {
            return;
        }
        DataNode javaProjectNode = ExternalSystemApiUtil.find((DataNode)node, (Key)JavaProjectData.KEY);
        if (javaProjectNode != null) {
            JavaProjectData data = (JavaProjectData)javaProjectNode.getData();
            context.setCompilerOutputDirectory(data.getCompileOutputPath());
            JavaSdkVersion version = data.getJdkVersion();
            Sdk jdk = GradleProjectImportBuilder.findJdk(version);
            if (jdk != null) {
                context.setProjectJdk(jdk);
            }
        }
    }

    private static Sdk findJdk(JavaSdkVersion version) {
        JavaSdk javaSdk = JavaSdk.getInstance();
        List javaSdks = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)javaSdk);
        Sdk candidate = null;
        for (Sdk sdk : javaSdks) {
            JavaSdkVersion v = javaSdk.getVersion(sdk);
            if (v == version) {
                return sdk;
            }
            if (candidate != null || v == null || !version.getMaxLanguageLevel().isAtLeast(version.getMaxLanguageLevel())) continue;
            candidate = sdk;
        }
        return candidate;
    }

    protected File getExternalProjectConfigToUse(File file) {
        return file.isDirectory() ? file : file.getParentFile();
    }

    public boolean isSuitableSdkType(SdkTypeId sdk) {
        return sdk == JavaSdk.getInstance();
    }
}

