/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project.data;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.DefaultExternalProject;
import com.intellij.openapi.externalSystem.model.ExternalProject;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataService;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectSerializer;

@Order(value=42)
public class ExternalProjectDataService
implements ProjectDataService<ExternalProject, Project> {
    private static final Logger LOG = Logger.getInstance(ExternalProjectDataService.class);
    public static final Key<ExternalProject> KEY = Key.create(ExternalProject.class, (int)(ProjectKeys.TASK.getProcessingWeight() + 1));
    private final Map<Pair<ProjectSystemId, File>, ExternalProject> myExternalRootProjects = new ConcurrentFactoryMap<Pair<ProjectSystemId, File>, ExternalProject>(){

        protected Map<Pair<ProjectSystemId, File>, ExternalProject> createMap() {
            return ContainerUtil.newConcurrentMap((TObjectHashingStrategy)ExternalSystemUtil.HASHING_STRATEGY);
        }

        protected ExternalProject create(Pair<ProjectSystemId, File> key) {
            return new ExternalProjectSerializer().load((ProjectSystemId)key.first, (File)key.second);
        }

        public ExternalProject put(Pair<ProjectSystemId, File> key, ExternalProject value) {
            new ExternalProjectSerializer().save(value);
            return (ExternalProject)super.put(key, (Object)value);
        }
    };

    public Key<ExternalProject> getTargetDataKey() {
        return KEY;
    }

    public void importData(Collection<DataNode<ExternalProject>> toImport, Project project, boolean synchronous) {
        if (toImport.size() != 1) {
            throw new IllegalArgumentException(String.format("Expected to get a single external project but got %d: %s", toImport.size(), toImport));
        }
        this.saveExternalProject((ExternalProject)toImport.iterator().next().getData());
    }

    public void removeData(Collection<? extends Project> modules, Project project, boolean synchronous) {
    }

    public ExternalProject getRootExternalProject(ProjectSystemId systemId, File projectRootDir) {
        ExternalProject externalProject = this.myExternalRootProjects.get(Pair.create((Object)systemId, (Object)projectRootDir));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Can not find data for project at: " + projectRootDir);
            LOG.debug("Existing imported projects paths: " + ContainerUtil.map(this.myExternalRootProjects.entrySet(), (Function)new Function<Map.Entry<Pair<ProjectSystemId, File>, ExternalProject>, Object>(){

                public Object fun(Map.Entry<Pair<ProjectSystemId, File>, ExternalProject> entry) {
                    if (!(entry.getValue() instanceof ExternalProject)) {
                        return null;
                    }
                    return Pair.create(entry.getKey(), (Object)entry.getValue().getProjectDir());
                }
            }));
        }
        return externalProject;
    }

    public void saveExternalProject(ExternalProject externalProject) {
        this.myExternalRootProjects.put((Pair<ProjectSystemId, File>)Pair.create((Object)new ProjectSystemId(externalProject.getExternalSystemId()), (Object)externalProject.getProjectDir()), (ExternalProject)new DefaultExternalProject(externalProject));
    }

    public ExternalProject findExternalProject(ExternalProject parentProject, Module module) {
        String externalProjectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        return externalProjectId != null ? ExternalProjectDataService.findExternalProject(parentProject, externalProjectId) : null;
    }

    private static ExternalProject findExternalProject(ExternalProject parentProject, String externalProjectId) {
        if (parentProject.getQName().equals(externalProjectId)) {
            return parentProject;
        }
        if (parentProject.getChildProjects().containsKey(externalProjectId)) {
            return (ExternalProject)parentProject.getChildProjects().get(externalProjectId);
        }
        for (ExternalProject externalProject : parentProject.getChildProjects().values()) {
            ExternalProject project = ExternalProjectDataService.findExternalProject(externalProject, externalProjectId);
            if (project == null) continue;
            return project;
        }
        return null;
    }
}

