/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.io.File;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleProjectImportNotificationListener
extends ExternalSystemTaskNotificationListenerAdapter {
    public void onTaskOutput(ExternalSystemTaskId id, String text, boolean stdOut) {
        Project project;
        if (!stdOut && !StringUtil.isEmpty((String)text) && GradleConstants.SYSTEM_ID.getId().equals(id.getProjectSystemId().getId()) && id.getType() == ExternalSystemTaskType.RESOLVE_PROJECT && (project = id.findProject()) != null && StringUtil.startsWith((CharSequence)text, (CharSequence)"<ij_msg_gr>")) {
            String group = GradleProjectImportNotificationListener.substringBetween(text, "<ij_msg_gr>", "<ij_msg_gr>");
            if (StringUtil.isEmpty((String)group)) {
                return;
            }
            int start = "<ij_msg_gr>".length() * 2 + group.length();
            String path = null;
            String errorMessage = text.substring(start);
            if (StringUtil.startsWith((CharSequence)errorMessage, (CharSequence)"<ij_nav>") && !StringUtil.isEmpty((String)(path = GradleProjectImportNotificationListener.substringBetween(errorMessage, "<ij_nav>", "<ij_nav>")))) {
                start += "<ij_nav>".length() * 2 + path.length();
            }
            errorMessage = text.substring(start).replaceAll("<eol>", "\n");
            NotificationData notification = new NotificationData(group, errorMessage, NotificationCategory.WARNING, NotificationSource.PROJECT_SYNC);
            if (path != null) {
                notification.setNavigatable((Navigatable)new MyNavigatable(new File(path), project));
            }
            ExternalSystemNotificationManager.getInstance((Project)project).showNotification(id.getProjectSystemId(), notification);
        }
    }

    private static String substringBetween(String str, String open, String close) {
        int start = str.indexOf(open);
        if (start == -1) {
            return null;
        }
        int end = str.indexOf(close, start + open.length());
        return end != -1 ? str.substring(start + open.length(), end) : null;
    }

    private static class MyNavigatable
    implements Navigatable {
        private final File myFile;
        private final Project myProject;
        private volatile OpenFileDescriptor openFileDescriptor;

        public MyNavigatable(File file, Project project) {
            this.myFile = file;
            this.myProject = project;
        }

        public void navigate(boolean requestFocus) {
            VirtualFile virtualFile;
            OpenFileDescriptor fileDescriptor = this.openFileDescriptor;
            if (fileDescriptor == null && (virtualFile = ExternalSystemUtil.findLocalFileByPath((String)this.myFile.getPath())) != null) {
                this.openFileDescriptor = fileDescriptor = new OpenFileDescriptor(this.myProject, virtualFile);
            }
            if (fileDescriptor != null && fileDescriptor.canNavigate()) {
                fileDescriptor.navigate(requestFocus);
            }
        }

        public boolean canNavigate() {
            return this.myFile.exists();
        }

        public boolean canNavigateToSource() {
            return this.canNavigate();
        }
    }
}

