/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.google.gson.GsonBuilder;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.externalSystem.JavaProjectData;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.DefaultExternalProject;
import com.intellij.openapi.externalSystem.model.ExternalProject;
import com.intellij.openapi.externalSystem.model.ExternalSourceDirectorySet;
import com.intellij.openapi.externalSystem.model.ExternalSourceSet;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ExternalTask;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemDebugEnvironment;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.KeyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.text.CharArrayUtil;
import groovy.lang.GroovyObject;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.GradleModuleVersion;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.UnsupportedMethodException;
import org.gradle.tooling.model.gradle.BasicGradleProject;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.tooling.model.idea.IdeaCompilerOutput;
import org.gradle.tooling.model.idea.IdeaContentRoot;
import org.gradle.tooling.model.idea.IdeaDependency;
import org.gradle.tooling.model.idea.IdeaDependencyScope;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.tooling.model.idea.IdeaModuleDependency;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.tooling.model.idea.IdeaSingleEntryLibraryDependency;
import org.gradle.tooling.model.idea.IdeaSourceDirectory;
import org.gradle.util.GradleVersion;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.ClasspathEntryModel;
import org.jetbrains.plugins.gradle.model.ExtIdeaContentRoot;
import org.jetbrains.plugins.gradle.model.ModuleExtendedModel;
import org.jetbrains.plugins.gradle.model.ProjectImportAction;
import org.jetbrains.plugins.gradle.model.data.BuildScriptClasspathData;
import org.jetbrains.plugins.gradle.service.project.BaseProjectImportErrorHandler;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolverExtension;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.service.project.data.ExternalProjectDataService;
import org.jetbrains.plugins.gradle.tooling.builder.ModelBuildScriptClasspathBuilderImpl;
import org.jetbrains.plugins.gradle.tooling.internal.init.Init;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;
import org.slf4j.Logger;
import org.slf4j.impl.Log4jLoggerFactory;

@Order(value=0x7FFFFFFF)
public class BaseGradleProjectResolverExtension
implements GradleProjectResolverExtension {
    private static final com.intellij.openapi.diagnostic.Logger LOG = com.intellij.openapi.diagnostic.Logger.getInstance((String)("#" + BaseGradleProjectResolverExtension.class.getName()));
    private static final String UNRESOLVED_DEPENDENCY_PREFIX = "unresolved dependency - ";
    private static final String MAIN_SOURCE_SET = "main";
    private static final String TEST_SOURCE_SET = "test";
    private ProjectResolverContext resolverCtx;
    private final BaseProjectImportErrorHandler myErrorHandler = new BaseProjectImportErrorHandler();

    @Override
    public void setProjectResolverContext(ProjectResolverContext projectResolverContext) {
        this.resolverCtx = projectResolverContext;
    }

    @Override
    public void setNext(GradleProjectResolverExtension next) {
    }

    @Override
    public GradleProjectResolverExtension getNext() {
        return null;
    }

    @Override
    public ProjectData createProject() {
        String projectDirPath = this.resolverCtx.getProjectPath();
        IdeaProject ideaProject = this.resolverCtx.getModels().getIdeaProject();
        return new ProjectData(GradleConstants.SYSTEM_ID, ideaProject.getName(), projectDirPath, projectDirPath);
    }

    @Override
    public JavaProjectData createJavaProjectData() {
        String projectDirPath = this.resolverCtx.getProjectPath();
        IdeaProject ideaProject = this.resolverCtx.getModels().getIdeaProject();
        JavaProjectData javaProjectData = new JavaProjectData(GradleConstants.SYSTEM_ID, projectDirPath + "/build/classes");
        javaProjectData.setJdkVersion(ideaProject.getJdkName());
        javaProjectData.setLanguageLevel(ideaProject.getLanguageLevel().getLevel());
        return javaProjectData;
    }

    @Override
    public void populateProjectExtraModels(IdeaProject gradleProject, DataNode<ProjectData> ideProject) {
        ExternalProject externalProject = this.resolverCtx.getExtraProject(ExternalProject.class);
        if (externalProject != null) {
            ideProject.createChild(ExternalProjectDataService.KEY, (Object)externalProject);
        }
    }

    @Override
    public ModuleData createModule(IdeaModule gradleModule, ProjectData projectData) {
        String gradlePath;
        String moduleName = gradleModule.getName();
        if (moduleName == null) {
            throw new IllegalStateException("Module with undefined name detected: " + gradleModule);
        }
        String moduleConfigPath = this.getModuleConfigPath(gradleModule, projectData.getLinkedExternalProjectPath());
        if (ExternalSystemDebugEnvironment.DEBUG_ORPHAN_MODULES_PROCESSING) {
            LOG.info(String.format("Creating module data ('%s') with the external config path: '%s'", gradleModule.getGradleProject().getPath(), moduleConfigPath));
        }
        String moduleId = StringUtil.isEmpty((String)(gradlePath = gradleModule.getGradleProject().getPath())) || ":".equals(gradlePath) ? moduleName : gradlePath;
        ModuleData moduleData = new ModuleData(moduleId, GradleConstants.SYSTEM_ID, StdModuleTypes.JAVA.getId(), moduleName, moduleConfigPath, moduleConfigPath);
        ModuleExtendedModel moduleExtendedModel = this.resolverCtx.getExtraProject(gradleModule, ModuleExtendedModel.class);
        if (moduleExtendedModel != null) {
            moduleData.setGroup(moduleExtendedModel.getGroup());
            moduleData.setVersion(moduleExtendedModel.getVersion());
            moduleData.setArtifacts(moduleExtendedModel.getArtifacts());
        }
        return moduleData;
    }

    @Override
    public void populateModuleExtraModels(IdeaModule gradleModule, DataNode<ModuleData> ideModule) {
        BuildScriptClasspathModel buildScriptClasspathModel = this.resolverCtx.getExtraProject(gradleModule, BuildScriptClasspathModel.class);
        List classpathEntries = buildScriptClasspathModel != null ? ContainerUtil.map((Collection)buildScriptClasspathModel.getClasspath(), (Function)new Function<ClasspathEntryModel, BuildScriptClasspathData.ClasspathEntry>(){

            public BuildScriptClasspathData.ClasspathEntry fun(ClasspathEntryModel model) {
                return new BuildScriptClasspathData.ClasspathEntry(model.getClasses(), model.getSources(), model.getJavadoc());
            }
        }) : ContainerUtil.emptyList();
        BuildScriptClasspathData buildScriptClasspathData = new BuildScriptClasspathData(GradleConstants.SYSTEM_ID, classpathEntries);
        ideModule.createChild(BuildScriptClasspathData.KEY, (Object)buildScriptClasspathData);
    }

    @Override
    public void populateModuleContentRoots(IdeaModule gradleModule, DataNode<ModuleData> ideModule) {
        ModuleExtendedModel moduleExtendedModel = this.resolverCtx.getExtraProject(gradleModule, ModuleExtendedModel.class);
        DomainObjectSet contentRoots = moduleExtendedModel != null ? moduleExtendedModel.getContentRoots() : gradleModule.getContentRoots();
        if (contentRoots == null) {
            return;
        }
        for (IdeaContentRoot gradleContentRoot : contentRoots) {
            Set excluded;
            File rootDirectory;
            if (gradleContentRoot == null || (rootDirectory = gradleContentRoot.getRootDirectory()) == null) continue;
            ContentRootData ideContentRoot = new ContentRootData(GradleConstants.SYSTEM_ID, rootDirectory.getAbsolutePath());
            ((ModuleData)ideModule.getData()).setModuleFileDirectoryPath(ideContentRoot.getRootPath());
            BaseGradleProjectResolverExtension.populateContentRoot(ideContentRoot, ExternalSystemSourceType.SOURCE, (Iterable<? extends IdeaSourceDirectory>)gradleContentRoot.getSourceDirectories());
            BaseGradleProjectResolverExtension.populateContentRoot(ideContentRoot, ExternalSystemSourceType.TEST, (Iterable<? extends IdeaSourceDirectory>)gradleContentRoot.getTestDirectories());
            if (gradleContentRoot instanceof ExtIdeaContentRoot) {
                ExtIdeaContentRoot extIdeaContentRoot = (ExtIdeaContentRoot)gradleContentRoot;
                BaseGradleProjectResolverExtension.populateContentRoot(ideContentRoot, ExternalSystemSourceType.RESOURCE, (Iterable<? extends IdeaSourceDirectory>)extIdeaContentRoot.getResourceDirectories());
                BaseGradleProjectResolverExtension.populateContentRoot(ideContentRoot, ExternalSystemSourceType.TEST_RESOURCE, (Iterable<? extends IdeaSourceDirectory>)extIdeaContentRoot.getTestResourceDirectories());
            }
            if ((excluded = gradleContentRoot.getExcludeDirectories()) != null) {
                for (File file : excluded) {
                    ideContentRoot.storePath(ExternalSystemSourceType.EXCLUDED, file.getAbsolutePath());
                }
            }
            ideModule.createChild(ProjectKeys.CONTENT_ROOT, (Object)ideContentRoot);
        }
    }

    @Override
    public void populateModuleCompileOutputSettings(IdeaModule gradleModule, DataNode<ModuleData> ideModule) {
        ExternalProject externalProject;
        IdeaCompilerOutput moduleCompilerOutput = gradleModule.getCompilerOutput();
        File buildDir = null;
        try {
            buildDir = gradleModule.getGradleProject().getBuildDirectory();
        }
        catch (UnsupportedMethodException ignore) {
            // empty catch block
        }
        HashMap compileOutputPaths = ContainerUtil.newHashMap();
        boolean inheritOutputDirs = false;
        ModuleData moduleData = (ModuleData)ideModule.getData();
        if (moduleCompilerOutput != null) {
            compileOutputPaths.put(ExternalSystemSourceType.SOURCE, moduleCompilerOutput.getOutputDir());
            compileOutputPaths.put(ExternalSystemSourceType.RESOURCE, moduleCompilerOutput.getOutputDir());
            compileOutputPaths.put(ExternalSystemSourceType.TEST, moduleCompilerOutput.getTestOutputDir());
            compileOutputPaths.put(ExternalSystemSourceType.TEST_RESOURCE, moduleCompilerOutput.getTestOutputDir());
            inheritOutputDirs = moduleCompilerOutput.getInheritOutputDirs();
        }
        if ((externalProject = this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class)) != null) {
            externalProject = new DefaultExternalProject(externalProject);
            File file = buildDir = buildDir == null ? externalProject.getBuildDir() : buildDir;
            if (!inheritOutputDirs) {
                File testCompileOutputPath;
                File sourceCompileOutputPath = (File)compileOutputPaths.get(ExternalSystemSourceType.SOURCE);
                if (sourceCompileOutputPath == null) {
                    BaseGradleProjectResolverExtension.addCompileOutputPath(compileOutputPaths, externalProject, MAIN_SOURCE_SET, ExternalSystemSourceType.SOURCE);
                    BaseGradleProjectResolverExtension.addCompileOutputPath(compileOutputPaths, externalProject, MAIN_SOURCE_SET, ExternalSystemSourceType.RESOURCE);
                }
                if ((testCompileOutputPath = (File)compileOutputPaths.get(ExternalSystemSourceType.TEST)) == null) {
                    BaseGradleProjectResolverExtension.addCompileOutputPath(compileOutputPaths, externalProject, TEST_SOURCE_SET, ExternalSystemSourceType.TEST);
                    BaseGradleProjectResolverExtension.addCompileOutputPath(compileOutputPaths, externalProject, TEST_SOURCE_SET, ExternalSystemSourceType.TEST_RESOURCE);
                }
            }
        } else {
            LOG.warn(String.format("Unable to get ExternalProject model for '%s'", gradleModule.getName()));
        }
        for (Map.Entry sourceTypeFileEntry : compileOutputPaths.entrySet()) {
            File outputPath = (File)ObjectUtils.chooseNotNull(sourceTypeFileEntry.getValue(), (Object)buildDir);
            if (outputPath == null) continue;
            moduleData.setCompileOutputPath((ExternalSystemSourceType)sourceTypeFileEntry.getKey(), outputPath.getAbsolutePath());
        }
        moduleData.setInheritProjectCompileOutputPath(inheritOutputDirs);
    }

    @Override
    public void populateModuleDependencies(IdeaModule gradleModule, DataNode<ModuleData> ideModule, DataNode<ProjectData> ideProject) {
        List dependencies = gradleModule.getDependencies().getAll();
        if (dependencies == null) {
            return;
        }
        for (IdeaDependency dependency : dependencies) {
            ModuleDependencyData d;
            if (dependency == null) continue;
            DependencyScope scope = BaseGradleProjectResolverExtension.parseScope(dependency.getScope());
            if (dependency instanceof IdeaModuleDependency) {
                d = BaseGradleProjectResolverExtension.buildDependency(ideModule, (IdeaModuleDependency)dependency, ideProject);
                d.setExported(dependency.getExported());
                if (scope != null) {
                    d.setScope(scope);
                }
                ideModule.createChild(ProjectKeys.MODULE_DEPENDENCY, (Object)d);
                continue;
            }
            if (!(dependency instanceof IdeaSingleEntryLibraryDependency)) continue;
            d = this.buildDependency(gradleModule, ideModule, (IdeaSingleEntryLibraryDependency)dependency, ideProject);
            d.setExported(dependency.getExported());
            if (scope != null) {
                d.setScope(scope);
            }
            ideModule.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)d);
        }
    }

    @Override
    public Collection<TaskData> populateModuleTasks(IdeaModule gradleModule, DataNode<ModuleData> ideModule, DataNode<ProjectData> ideProject) throws IllegalArgumentException, IllegalStateException {
        ArrayList tasks = ContainerUtil.newArrayList();
        String moduleConfigPath = ((ModuleData)ideModule.getData()).getLinkedExternalProjectPath();
        ExternalProject externalProject = this.resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        if (externalProject != null) {
            for (ExternalTask task : externalProject.getTasks().values()) {
                String taskName = task.getName();
                if (taskName.trim().isEmpty() || BaseGradleProjectResolverExtension.isIdeaTask(taskName)) continue;
                TaskData taskData = new TaskData(GradleConstants.SYSTEM_ID, taskName, moduleConfigPath, task.getDescription());
                taskData.setGroup(task.getGroup());
                ideModule.createChild(ProjectKeys.TASK, (Object)taskData);
                taskData.setInherited(StringUtil.equals((CharSequence)task.getName(), (CharSequence)task.getQName()));
                tasks.add(taskData);
            }
            return tasks;
        }
        for (GradleTask task : gradleModule.getGradleProject().getTasks()) {
            String taskName = task.getName();
            if (taskName == null || taskName.trim().isEmpty() || BaseGradleProjectResolverExtension.isIdeaTask(taskName)) continue;
            TaskData taskData = new TaskData(GradleConstants.SYSTEM_ID, taskName, moduleConfigPath, task.getDescription());
            ideModule.createChild(ProjectKeys.TASK, (Object)taskData);
            tasks.add(taskData);
        }
        return tasks;
    }

    @Override
    public Collection<TaskData> filterRootProjectTasks(List<TaskData> allTasks) {
        return allTasks;
    }

    @Override
    public Set<Class> getExtraProjectModelClasses() {
        Set result = ContainerUtil.set((Object[])new Class[]{GradleBuild.class, ExternalProject.class, ModuleExtendedModel.class});
        if (!ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID) || !this.resolverCtx.isPreviewMode()) {
            result.add(BuildScriptClasspathModel.class);
        }
        return result;
    }

    @Override
    public Set<Class> getToolingExtensionsClasses() {
        return ContainerUtil.set((Object[])new Class[]{ExternalProject.class, ProjectImportAction.class, ModelBuildScriptClasspathBuilderImpl.class, GsonBuilder.class, ShortTypeHandling.class});
    }

    @Override
    public List<KeyValue<String, String>> getExtraJvmArgs() {
        if (ExternalSystemApiUtil.isInProcessMode((ProjectSystemId)GradleConstants.SYSTEM_ID)) {
            List hosts;
            ArrayList extraJvmArgs = ContainerUtil.newArrayList();
            HttpConfigurable httpConfigurable = HttpConfigurable.getInstance();
            if (!StringUtil.isEmpty((String)httpConfigurable.PROXY_EXCEPTIONS) && !(hosts = StringUtil.split((String)httpConfigurable.PROXY_EXCEPTIONS, (String)",")).isEmpty()) {
                String nonProxyHosts = StringUtil.join((Collection)hosts, (Function)StringUtil.TRIMMER, (String)"|");
                extraJvmArgs.add(KeyValue.create((Object)"http.nonProxyHosts", (Object)nonProxyHosts));
                extraJvmArgs.add(KeyValue.create((Object)"https.nonProxyHosts", (Object)nonProxyHosts));
            }
            if (httpConfigurable.USE_HTTP_PROXY && StringUtil.isNotEmpty((String)httpConfigurable.PROXY_LOGIN)) {
                extraJvmArgs.add(KeyValue.create((Object)"http.proxyUser", (Object)httpConfigurable.PROXY_LOGIN));
                extraJvmArgs.add(KeyValue.create((Object)"https.proxyUser", (Object)httpConfigurable.PROXY_LOGIN));
                String plainProxyPassword = httpConfigurable.getPlainProxyPassword();
                extraJvmArgs.add(KeyValue.create((Object)"http.proxyPassword", (Object)plainProxyPassword));
                extraJvmArgs.add(KeyValue.create((Object)"https.proxyPassword", (Object)plainProxyPassword));
            }
            extraJvmArgs.addAll(HttpConfigurable.getJvmPropertiesList((boolean)false, null));
            return extraJvmArgs;
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getExtraCommandLineArgs() {
        return Collections.emptyList();
    }

    @Override
    public ExternalSystemException getUserFriendlyError(Throwable error, String projectPath, String buildFilePath) {
        return this.myErrorHandler.getUserFriendlyError(error, projectPath, buildFilePath);
    }

    @Override
    public void preImportCheck() {
    }

    @Override
    public void enhanceTaskProcessing(List<String> taskNames, String debuggerSetup, Consumer<String> initScriptConsumer) {
        if (!StringUtil.isEmpty((String)debuggerSetup)) {
            String[] lines = new String[]{"gradle.taskGraph.beforeTask { Task task ->", "    if (task instanceof JavaForkOptions) {", "        def jvmArgs = task.jvmArgs.findAll{!it?.startsWith('-agentlib') && !it?.startsWith('-Xrunjdwp')}", "        jvmArgs << '" + debuggerSetup.trim() + '\'', "        task.jvmArgs jvmArgs", "    }}"};
            String script = StringUtil.join((String[])lines, (String)SystemProperties.getLineSeparator());
            initScriptConsumer.consume((Object)script);
        }
    }

    public void enhanceRemoteProcessing(SimpleJavaParameters parameters) throws ExecutionException {
        PathsList classPath = parameters.getClassPath();
        ExternalSystemApiUtil.addBundle((PathsList)classPath, (String)"i18n.GradleBundle", GradleBundle.class);
        String toolingApiPath = PathManager.getJarPathForClass(ProjectConnection.class);
        if (toolingApiPath == null) {
            LOG.warn(GradleBundle.message("gradle.generic.text.error.jar.not.found", new Object[0]));
            throw new ExecutionException("Can't find gradle libraries");
        }
        File gradleJarsDir = new File(toolingApiPath).getParentFile();
        String[] gradleJars = gradleJarsDir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (gradleJars == null) {
            LOG.warn(GradleBundle.message("gradle.generic.text.error.jar.not.found", new Object[0]));
            throw new ExecutionException("Can't find gradle libraries at " + gradleJarsDir.getAbsolutePath());
        }
        for (String jar : gradleJars) {
            classPath.add(new File(gradleJarsDir, jar).getAbsolutePath());
        }
        ArrayList additionalEntries = ContainerUtilRt.newArrayList();
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(GroovyObject.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(GsonBuilder.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(ExternalProject.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(JavaProjectData.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(LanguageLevel.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(StdModuleTypes.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(JavaModuleType.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(ModuleType.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(EmptyModuleType.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(ProjectImportAction.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(Init.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(Logger.class));
        ContainerUtilRt.addIfNotNull((Collection)additionalEntries, (Object)PathUtil.getJarPathForClass(Log4jLoggerFactory.class));
        for (String entry : additionalEntries) {
            classPath.add(entry);
        }
    }

    public void enhanceLocalProcessing(List<URL> urls) {
    }

    private String getModuleConfigPath(IdeaModule gradleModule, String rootProjectPath) {
        GradleBuild build = this.resolverCtx.getExtraProject(gradleModule, GradleBuild.class);
        if (build != null) {
            String gradlePath = gradleModule.getGradleProject().getPath();
            File moduleDirPath = BaseGradleProjectResolverExtension.getModuleDirPath(build, gradlePath);
            if (moduleDirPath == null) {
                throw new IllegalStateException(String.format("Unable to find root directory for module '%s'", gradleModule.getName()));
            }
            try {
                return ExternalSystemApiUtil.toCanonicalPath((String)moduleDirPath.getCanonicalPath());
            }
            catch (IOException e) {
                LOG.warn("construction of the canonical path for the module fails", (Throwable)e);
            }
        }
        return GradleUtil.getConfigPath(gradleModule.getGradleProject(), rootProjectPath);
    }

    static File getModuleDirPath(GradleBuild build, String path) {
        for (BasicGradleProject project : build.getProjects()) {
            if (!project.getPath().equals(path)) continue;
            return project.getProjectDirectory();
        }
        return null;
    }

    private static void populateContentRoot(ContentRootData contentRoot, ExternalSystemSourceType type, Iterable<? extends IdeaSourceDirectory> dirs) throws IllegalArgumentException {
        if (dirs == null) {
            return;
        }
        for (IdeaSourceDirectory ideaSourceDirectory : dirs) {
            ExternalSystemSourceType dirSourceType = type;
            try {
                if (ideaSourceDirectory.isGenerated() && !dirSourceType.isGenerated()) {
                    ExternalSystemSourceType generatedType = ExternalSystemSourceType.from((boolean)dirSourceType.isTest(), (boolean)ideaSourceDirectory.isGenerated(), (boolean)dirSourceType.isResource(), (boolean)dirSourceType.isExcluded());
                    dirSourceType = generatedType != null ? generatedType : dirSourceType;
                }
            }
            catch (UnsupportedMethodException e) {
                LOG.warn(e.getMessage());
                BaseGradleProjectResolverExtension.printToolingProxyDiagnosticInfo(ideaSourceDirectory);
            }
            catch (Throwable e) {
                LOG.debug(e);
                BaseGradleProjectResolverExtension.printToolingProxyDiagnosticInfo(ideaSourceDirectory);
            }
            contentRoot.storePath(dirSourceType, ideaSourceDirectory.getDirectory().getAbsolutePath());
        }
    }

    private static void printToolingProxyDiagnosticInfo(Object obj) {
        if (!LOG.isDebugEnabled() || obj == null) {
            return;
        }
        LOG.debug(String.format("obj: %s", obj));
        Class<?> aClass = obj.getClass();
        LOG.debug(String.format("obj class: %s", aClass));
        LOG.debug(String.format("classloader: %s", aClass.getClassLoader()));
        for (Method m : aClass.getDeclaredMethods()) {
            LOG.debug(String.format("obj m: %s", m));
        }
        if (obj instanceof Proxy) {
            try {
                Field hField = ReflectionUtil.findField(obj.getClass(), null, (String)"h");
                hField.setAccessible(true);
                Object h = hField.get(obj);
                Field delegateField = ReflectionUtil.findField(h.getClass(), null, (String)"delegate");
                delegateField.setAccessible(true);
                Object delegate = delegateField.get(h);
                LOG.debug(String.format("delegate: %s", delegate));
                LOG.debug(String.format("delegate class: %s", delegate.getClass()));
                LOG.debug(String.format("delegate classloader: %s", delegate.getClass().getClassLoader()));
                for (Method m : delegate.getClass().getDeclaredMethods()) {
                    LOG.debug(String.format("delegate m: %s", m));
                }
            }
            catch (NoSuchFieldException e) {
                LOG.debug((Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    private static DependencyScope parseScope(IdeaDependencyScope scope) {
        if (scope == null) {
            return null;
        }
        String scopeAsString = scope.getScope();
        if (scopeAsString == null) {
            return null;
        }
        for (DependencyScope dependencyScope : DependencyScope.values()) {
            if (!scopeAsString.equalsIgnoreCase(dependencyScope.toString())) continue;
            return dependencyScope;
        }
        return null;
    }

    private static ModuleDependencyData buildDependency(DataNode<ModuleData> ownerModule, IdeaModuleDependency dependency, DataNode<ProjectData> ideProject) throws IllegalStateException {
        IdeaModule module = dependency.getDependencyModule();
        if (module == null) {
            throw new IllegalStateException(String.format("Can't parse gradle module dependency '%s'. Reason: referenced module is null", dependency));
        }
        String moduleName = module.getName();
        if (moduleName == null) {
            throw new IllegalStateException(String.format("Can't parse gradle module dependency '%s'. Reason: referenced module name is undefined (module: '%s') ", dependency, module));
        }
        HashSet registeredModuleNames = ContainerUtilRt.newHashSet();
        Collection modulesDataNode = ExternalSystemApiUtil.getChildren(ideProject, (Key)ProjectKeys.MODULE);
        for (DataNode moduleDataNode : modulesDataNode) {
            String name = ((ModuleData)moduleDataNode.getData()).getExternalName();
            registeredModuleNames.add(name);
            if (!name.equals(moduleName)) continue;
            return new ModuleDependencyData((ModuleData)ownerModule.getData(), (ModuleData)moduleDataNode.getData());
        }
        throw new IllegalStateException(String.format("Can't parse gradle module dependency '%s'. Reason: no module with such name (%s) is found. Registered modules: %s", dependency, moduleName, registeredModuleNames));
    }

    private LibraryDependencyData buildDependency(IdeaModule gradleModule, DataNode<ModuleData> ownerModule, IdeaSingleEntryLibraryDependency dependency, DataNode<ProjectData> ideProject) throws IllegalStateException {
        DataNode libraryData;
        String libraryName;
        LibraryLevel level;
        File binaryPath = dependency.getFile();
        if (binaryPath == null) {
            throw new IllegalStateException(String.format("Can't parse external library dependency '%s'. Reason: it doesn't specify path to the binaries", dependency));
        }
        GradleModuleVersion moduleVersion = dependency.getGradleModuleVersion();
        boolean unresolved = binaryPath.getPath().startsWith(UNRESOLVED_DEPENDENCY_PREFIX);
        if (moduleVersion == null) {
            level = LibraryLevel.MODULE;
            libraryName = binaryPath.isFile() ? FileUtil.getNameWithoutExtension((File)binaryPath) : FileUtil.sanitizeFileName((String)binaryPath.getPath());
            if (unresolved) {
                int dependencyNameIndex;
                libraryName = binaryPath.getPath().substring(UNRESOLVED_DEPENDENCY_PREFIX.length());
                int i = libraryName.indexOf(32);
                if (i >= 0) {
                    i = CharArrayUtil.shiftForward((CharSequence)libraryName, (int)(i + 1), (String)" ");
                }
                if (i >= 0 && i < libraryName.length() && (i = libraryName.indexOf(32, dependencyNameIndex = i)) > 0) {
                    libraryName = String.format("%s-%s", libraryName.substring(dependencyNameIndex, i), libraryName.substring(i + 1));
                }
            }
        } else {
            level = LibraryLevel.PROJECT;
            libraryName = String.format("%s:%s:%s", moduleVersion.getGroup(), moduleVersion.getName(), moduleVersion.getVersion());
            if (binaryPath.isFile()) {
                String libraryFileName = FileUtil.getNameWithoutExtension((File)binaryPath);
                String mavenLibraryFileName = String.format("%s-%s", moduleVersion.getName(), moduleVersion.getVersion());
                if (!mavenLibraryFileName.equals(libraryFileName)) {
                    Pattern pattern = Pattern.compile(moduleVersion.getName() + "-" + moduleVersion.getVersion() + "-(.*)");
                    Matcher matcher = pattern.matcher(libraryFileName);
                    if (matcher.matches()) {
                        String classifier = matcher.group(1);
                        libraryName = libraryName + ":" + classifier;
                    } else {
                        String artifactId = StringUtil.trimEnd((String)StringUtil.trimEnd((String)libraryFileName, (String)moduleVersion.getVersion()), (String)"-");
                        libraryName = String.format("%s:%s:%s", moduleVersion.getGroup(), artifactId, moduleVersion.getVersion());
                    }
                }
            }
        }
        final LibraryData library = new LibraryData(GradleConstants.SYSTEM_ID, libraryName, unresolved);
        if (!unresolved) {
            library.addPath(LibraryPathType.BINARY, binaryPath.getAbsolutePath());
        }
        File sourcePath = dependency.getSource();
        if (!unresolved && sourcePath != null) {
            library.addPath(LibraryPathType.SOURCE, sourcePath.getAbsolutePath());
        }
        if (!unresolved && sourcePath == null) {
            this.attachGradleSdkSources(gradleModule, libraryName, binaryPath, library);
        }
        File javadocPath = dependency.getJavadoc();
        if (!unresolved && javadocPath != null) {
            library.addPath(LibraryPathType.DOC, javadocPath.getAbsolutePath());
        }
        if (level == LibraryLevel.PROJECT && (libraryData = ExternalSystemApiUtil.find(ideProject, (Key)ProjectKeys.LIBRARY, (BooleanFunction)new BooleanFunction<DataNode<LibraryData>>(){

            public boolean fun(DataNode<LibraryData> node) {
                return library.equals(node.getData());
            }
        })) == null) {
            ideProject.createChild(ProjectKeys.LIBRARY, (Object)library);
        }
        return new LibraryDependencyData((ModuleData)ownerModule.getData(), library, level);
    }

    private void attachGradleSdkSources(IdeaModule gradleModule, String libName, File libFile, LibraryData library) {
        if (libFile == null || !libName.startsWith("gradle-")) {
            return;
        }
        BuildScriptClasspathModel buildScriptClasspathModel = this.resolverCtx.getExtraProject(gradleModule, BuildScriptClasspathModel.class);
        if (buildScriptClasspathModel == null) {
            return;
        }
        File gradleHomeDir = buildScriptClasspathModel.getGradleHomeDir();
        if (gradleHomeDir == null) {
            return;
        }
        if (!FileUtil.isAncestor((File)gradleHomeDir, (File)libFile, (boolean)true)) {
            return;
        }
        File libOrPluginsFile = libFile.getParentFile();
        if (libOrPluginsFile != null && "plugins".equals(libOrPluginsFile.getName())) {
            libOrPluginsFile = libOrPluginsFile.getParentFile();
        }
        if (libOrPluginsFile != null && "lib".equals(libOrPluginsFile.getName()) && libOrPluginsFile.getParentFile() != null) {
            int endIndex;
            File srcDir = new File(libOrPluginsFile.getParentFile(), "src");
            GradleVersion current = GradleVersion.version((String)buildScriptClasspathModel.getGradleVersion());
            if (current.compareTo(GradleVersion.version((String)"1.9")) >= 0 && (endIndex = libName.indexOf(current.getVersion())) != -1) {
                String srcDirChild = libName.substring("gradle-".length(), endIndex - 1);
                srcDir = new File(srcDir, srcDirChild);
            }
            if (srcDir.isDirectory()) {
                library.addPath(LibraryPathType.SOURCE, srcDir.getAbsolutePath());
            }
        }
    }

    private static boolean isIdeaTask(String taskName) {
        return taskName.toLowerCase(Locale.ENGLISH).contains("idea");
    }

    private static void addCompileOutputPath(Map<ExternalSystemSourceType, File> compileOutputPaths, ExternalProject externalProject, String sourceSetName, ExternalSystemSourceType sourceType) {
        ExternalSourceSet sourceSet = (ExternalSourceSet)externalProject.getSourceSets().get(sourceSetName);
        if (sourceSet == null) {
            return;
        }
        ExternalSourceDirectorySet directorySet = (ExternalSourceDirectorySet)sourceSet.getSources().get(sourceType);
        if (directorySet != null) {
            compileOutputPaths.put(sourceType, directorySet.getOutputDir());
        }
    }
}

