/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.execution.TaskCompletionProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.ui.TextAccessor;
import com.intellij.util.containers.ContainerUtil;
import icons.ExternalSystemIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.plugins.gradle.service.execution.cmd.GradleCommandLineOptionsProvider;
import org.jetbrains.plugins.gradle.util.GradleConstants;

public class GradleArgumentsCompletionProvider
extends TaskCompletionProvider {
    public GradleArgumentsCompletionProvider(Project project, TextAccessor workDirectoryField) {
        super(project, GradleConstants.SYSTEM_ID, workDirectoryField, GradleCommandLineOptionsProvider.getSupportedOptions());
    }

    protected List<LookupElement> getVariants(DataNode<ProjectData> projectDataNode, String modulePath) {
        DataNode moduleDataNode = GradleArgumentsCompletionProvider.findModuleDataNode(projectDataNode, (String)modulePath);
        if (moduleDataNode == null) {
            return Collections.emptyList();
        }
        ModuleData moduleData = (ModuleData)moduleDataNode.getData();
        boolean isRoot = ((ProjectData)projectDataNode.getData()).getLinkedExternalProjectPath().equals(moduleData.getLinkedExternalProjectPath());
        Collection tasks = ExternalSystemApiUtil.getChildren((DataNode)moduleDataNode, (Key)ProjectKeys.TASK);
        ArrayList elements = ContainerUtil.newArrayListWithCapacity((int)tasks.size());
        for (DataNode taskDataNode : tasks) {
            TaskData taskData = (TaskData)taskDataNode.getData();
            elements.add(LookupElementBuilder.create((String)taskData.getName()).withIcon(ExternalSystemIcons.Task));
            if (taskData.isInherited()) continue;
            elements.add(LookupElementBuilder.create((String)((isRoot ? Character.valueOf(':') : moduleData.getId() + ':') + taskData.getName())).withIcon(ExternalSystemIcons.Task));
        }
        return elements;
    }
}

