/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model.data;

import java.io.File;
import java.io.Serializable;
import org.jetbrains.plugins.gradle.model.data.WarDirectory;

public class WebResource
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final WarDirectory myWarDirectory;
    private final String warRelativePath;
    private final File file;

    public WebResource(WarDirectory warDirectory, String warRelativePath, File file) {
        this.myWarDirectory = warDirectory;
        this.warRelativePath = WebResource.getAdjustedPath(warRelativePath);
        this.file = file;
    }

    public WarDirectory getWarDirectory() {
        return this.myWarDirectory;
    }

    public String getWarRelativePath() {
        return this.warRelativePath;
    }

    public File getFile() {
        return this.file;
    }

    private static String getAdjustedPath(String path) {
        return path.isEmpty() || path.charAt(0) != '/' ? '/' + path : path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WebResource)) {
            return false;
        }
        WebResource resource = (WebResource)o;
        if (!this.file.getPath().equals(resource.file.getPath())) {
            return false;
        }
        if (this.myWarDirectory != resource.myWarDirectory) {
            return false;
        }
        return this.warRelativePath.equals(resource.warRelativePath);
    }

    public int hashCode() {
        int result = this.myWarDirectory.hashCode();
        result = 31 * result + this.warRelativePath.hashCode();
        result = 31 * result + this.file.getPath().hashCode();
        return result;
    }

    public String toString() {
        return "WebResource{myWarDirectory=" + this.myWarDirectory + ", warRelativePath='" + this.warRelativePath + '\'' + ", file=" + this.file + '}';
    }
}

